/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.query.LogsQueryAsyncClient;
import com.azure.monitor.query.LogsQueryClient;
import com.azure.monitor.query.LogsQueryServiceVersion;
import com.azure.monitor.query.implementation.logs.AzureLogAnalyticsImplBuilder;

@ServiceClientBuilder(serviceClients={LogsQueryClient.class, LogsQueryAsyncClient.class})
public final class LogsQueryClientBuilder {
    private final ClientLogger logger = new ClientLogger(LogsQueryClientBuilder.class);
    private final AzureLogAnalyticsImplBuilder innerLogBuilder = new AzureLogAnalyticsImplBuilder();
    private ClientOptions clientOptions;
    private LogsQueryServiceVersion serviceVersion;

    public LogsQueryClientBuilder endpoint(String endpoint) {
        this.innerLogBuilder.host(endpoint);
        return this;
    }

    public LogsQueryClientBuilder pipeline(HttpPipeline pipeline) {
        this.innerLogBuilder.pipeline(pipeline);
        return this;
    }

    public LogsQueryClientBuilder httpClient(HttpClient httpClient) {
        this.innerLogBuilder.httpClient(httpClient);
        return this;
    }

    public LogsQueryClientBuilder configuration(Configuration configuration) {
        this.innerLogBuilder.configuration(configuration);
        return this;
    }

    public LogsQueryClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.innerLogBuilder.httpLogOptions(httpLogOptions);
        return this;
    }

    public LogsQueryClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.innerLogBuilder.retryPolicy(retryPolicy);
        return this;
    }

    public LogsQueryClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.innerLogBuilder.addPolicy(customPolicy);
        return this;
    }

    public LogsQueryClientBuilder credential(TokenCredential tokenCredential) {
        this.innerLogBuilder.credential(tokenCredential);
        return this;
    }

    public LogsQueryClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public LogsQueryClientBuilder serviceVersion(LogsQueryServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public LogsQueryClient buildClient() {
        return new LogsQueryClient(this.buildAsyncClient());
    }

    public LogsQueryAsyncClient buildAsyncClient() {
        this.logger.info("Using service version " + (Object)((Object)this.serviceVersion));
        return new LogsQueryAsyncClient(this.innerLogBuilder.buildClient());
    }
}

