// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Contains a batch of document write actions to send to the index.
 */
@Immutable
public final class IndexBatch implements JsonSerializable<IndexBatch> {
    /*
     * The actions in the batch.
     */
    private final List<IndexAction> actions;

    /**
     * Creates an instance of IndexBatch class.
     * 
     * @param actions the actions value to set.
     */
    public IndexBatch(List<IndexAction> actions) {
        this.actions = actions;
    }

    /**
     * Get the actions property: The actions in the batch.
     * 
     * @return the actions value.
     */
    public List<IndexAction> getActions() {
        return this.actions;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.actions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IndexBatch from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IndexBatch if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IndexBatch.
     */
    public static IndexBatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean actionsFound = false;
            List<IndexAction> actions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    actions = reader.readArray(reader1 -> IndexAction.fromJson(reader1));
                    actionsFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (actionsFound) {
                return new IndexBatch(actions);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}
