// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CharFilterName;
import com.azure.search.documents.indexes.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.models.LexicalTokenizerName;
import com.azure.search.documents.indexes.models.TokenFilterName;
import java.io.IOException;
import java.util.List;

/**
 * Specifies some text and analysis components used to break that text into tokens.
 */
@Fluent
public final class AnalyzeRequest implements JsonSerializable<AnalyzeRequest> {
    /*
     * The text to break into tokens.
     */
    private final String text;

    /*
     * The name of the analyzer to use to break the given text. If this parameter is not specified, you must specify a
     * tokenizer instead. The tokenizer and analyzer parameters are mutually exclusive.
     */
    private LexicalAnalyzerName analyzer;

    /*
     * The name of the tokenizer to use to break the given text. If this parameter is not specified, you must specify an
     * analyzer instead. The tokenizer and analyzer parameters are mutually exclusive.
     */
    private LexicalTokenizerName tokenizer;

    /*
     * An optional list of token filters to use when breaking the given text. This parameter can only be set when using
     * the tokenizer parameter.
     */
    private List<TokenFilterName> tokenFilters;

    /*
     * An optional list of character filters to use when breaking the given text. This parameter can only be set when
     * using the tokenizer parameter.
     */
    private List<CharFilterName> charFilters;

    /**
     * Creates an instance of AnalyzeRequest class.
     * 
     * @param text the text value to set.
     */
    public AnalyzeRequest(String text) {
        this.text = text;
    }

    /**
     * Get the text property: The text to break into tokens.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Get the analyzer property: The name of the analyzer to use to break the given text. If this parameter is not
     * specified, you must specify a tokenizer instead. The tokenizer and analyzer parameters are mutually exclusive.
     * 
     * @return the analyzer value.
     */
    public LexicalAnalyzerName getAnalyzer() {
        return this.analyzer;
    }

    /**
     * Set the analyzer property: The name of the analyzer to use to break the given text. If this parameter is not
     * specified, you must specify a tokenizer instead. The tokenizer and analyzer parameters are mutually exclusive.
     * 
     * @param analyzer the analyzer value to set.
     * @return the AnalyzeRequest object itself.
     */
    public AnalyzeRequest setAnalyzer(LexicalAnalyzerName analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    /**
     * Get the tokenizer property: The name of the tokenizer to use to break the given text. If this parameter is not
     * specified, you must specify an analyzer instead. The tokenizer and analyzer parameters are mutually exclusive.
     * 
     * @return the tokenizer value.
     */
    public LexicalTokenizerName getTokenizer() {
        return this.tokenizer;
    }

    /**
     * Set the tokenizer property: The name of the tokenizer to use to break the given text. If this parameter is not
     * specified, you must specify an analyzer instead. The tokenizer and analyzer parameters are mutually exclusive.
     * 
     * @param tokenizer the tokenizer value to set.
     * @return the AnalyzeRequest object itself.
     */
    public AnalyzeRequest setTokenizer(LexicalTokenizerName tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    /**
     * Get the tokenFilters property: An optional list of token filters to use when breaking the given text. This
     * parameter can only be set when using the tokenizer parameter.
     * 
     * @return the tokenFilters value.
     */
    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    /**
     * Set the tokenFilters property: An optional list of token filters to use when breaking the given text. This
     * parameter can only be set when using the tokenizer parameter.
     * 
     * @param tokenFilters the tokenFilters value to set.
     * @return the AnalyzeRequest object itself.
     */
    public AnalyzeRequest setTokenFilters(List<TokenFilterName> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    /**
     * Get the charFilters property: An optional list of character filters to use when breaking the given text. This
     * parameter can only be set when using the tokenizer parameter.
     * 
     * @return the charFilters value.
     */
    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    /**
     * Set the charFilters property: An optional list of character filters to use when breaking the given text. This
     * parameter can only be set when using the tokenizer parameter.
     * 
     * @param charFilters the charFilters value to set.
     * @return the AnalyzeRequest object itself.
     */
    public AnalyzeRequest setCharFilters(List<CharFilterName> charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("analyzer", this.analyzer == null ? null : this.analyzer.toString());
        jsonWriter.writeStringField("tokenizer", this.tokenizer == null ? null : this.tokenizer.toString());
        jsonWriter.writeArrayField("tokenFilters", this.tokenFilters,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("charFilters", this.charFilters,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyzeRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyzeRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AnalyzeRequest.
     */
    public static AnalyzeRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean textFound = false;
            String text = null;
            LexicalAnalyzerName analyzer = null;
            LexicalTokenizerName tokenizer = null;
            List<TokenFilterName> tokenFilters = null;
            List<CharFilterName> charFilters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    textFound = true;
                } else if ("analyzer".equals(fieldName)) {
                    analyzer = LexicalAnalyzerName.fromString(reader.getString());
                } else if ("tokenizer".equals(fieldName)) {
                    tokenizer = LexicalTokenizerName.fromString(reader.getString());
                } else if ("tokenFilters".equals(fieldName)) {
                    tokenFilters = reader.readArray(reader1 -> TokenFilterName.fromString(reader1.getString()));
                } else if ("charFilters".equals(fieldName)) {
                    charFilters = reader.readArray(reader1 -> CharFilterName.fromString(reader1.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            if (textFound) {
                AnalyzeRequest deserializedAnalyzeRequest = new AnalyzeRequest(text);
                deserializedAnalyzeRequest.analyzer = analyzer;
                deserializedAnalyzeRequest.tokenizer = tokenizer;
                deserializedAnalyzeRequest.tokenFilters = tokenFilters;
                deserializedAnalyzeRequest.charFilters = charFilters;

                return deserializedAnalyzeRequest;
            }
            throw new IllegalStateException("Missing required property: text");
        });
    }
}
