// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Defines the names of all character filters supported by the search engine.
 */
public final class CharFilterName extends ExpandableStringEnum<CharFilterName> {
    /**
     * A character filter that attempts to strip out HTML constructs. See
     * https://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/charfilter/HTMLStripCharFilter.html.
     */
    public static final CharFilterName HTML_STRIP = fromString("html_strip");

    /**
     * Creates a new instance of CharFilterName value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CharFilterName() {
    }

    /**
     * Creates or finds a CharFilterName from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding CharFilterName.
     */
    public static CharFilterName fromString(String name) {
        return fromString(name, CharFilterName.class);
    }

    /**
     * Gets known CharFilterName values.
     * 
     * @return known CharFilterName values.
     */
    public static Collection<CharFilterName> values() {
        return values(CharFilterName.class);
    }
}
