// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains the parameters specific to the HNSW algorithm.
 */
@Fluent
public final class HnswParameters implements JsonSerializable<HnswParameters> {
    /*
     * The number of bi-directional links created for every new element during construction. Increasing this parameter
     * value may improve recall and reduce retrieval times for datasets with high intrinsic dimensionality at the
     * expense of increased memory consumption and longer indexing time.
     */
    private Integer m;

    /*
     * The size of the dynamic list containing the nearest neighbors, which is used during index time. Increasing this
     * parameter may improve index quality, at the expense of increased indexing time. At a certain point, increasing
     * this parameter leads to diminishing returns.
     */
    private Integer efConstruction;

    /*
     * The size of the dynamic list containing the nearest neighbors, which is used during search time. Increasing this
     * parameter may improve search results, at the expense of slower search. At a certain point, increasing this
     * parameter leads to diminishing returns.
     */
    private Integer efSearch;

    /*
     * The similarity metric to use for vector comparisons.
     */
    private VectorSearchAlgorithmMetric metric;

    /**
     * Creates an instance of HnswParameters class.
     */
    public HnswParameters() {
    }

    /**
     * Get the m property: The number of bi-directional links created for every new element during construction.
     * Increasing this parameter value may improve recall and reduce retrieval times for datasets with high intrinsic
     * dimensionality at the expense of increased memory consumption and longer indexing time.
     * 
     * @return the m value.
     */
    public Integer getM() {
        return this.m;
    }

    /**
     * Set the m property: The number of bi-directional links created for every new element during construction.
     * Increasing this parameter value may improve recall and reduce retrieval times for datasets with high intrinsic
     * dimensionality at the expense of increased memory consumption and longer indexing time.
     * 
     * @param m the m value to set.
     * @return the HnswParameters object itself.
     */
    public HnswParameters setM(Integer m) {
        this.m = m;
        return this;
    }

    /**
     * Get the efConstruction property: The size of the dynamic list containing the nearest neighbors, which is used
     * during index time. Increasing this parameter may improve index quality, at the expense of increased indexing
     * time. At a certain point, increasing this parameter leads to diminishing returns.
     * 
     * @return the efConstruction value.
     */
    public Integer getEfConstruction() {
        return this.efConstruction;
    }

    /**
     * Set the efConstruction property: The size of the dynamic list containing the nearest neighbors, which is used
     * during index time. Increasing this parameter may improve index quality, at the expense of increased indexing
     * time. At a certain point, increasing this parameter leads to diminishing returns.
     * 
     * @param efConstruction the efConstruction value to set.
     * @return the HnswParameters object itself.
     */
    public HnswParameters setEfConstruction(Integer efConstruction) {
        this.efConstruction = efConstruction;
        return this;
    }

    /**
     * Get the efSearch property: The size of the dynamic list containing the nearest neighbors, which is used during
     * search time. Increasing this parameter may improve search results, at the expense of slower search. At a certain
     * point, increasing this parameter leads to diminishing returns.
     * 
     * @return the efSearch value.
     */
    public Integer getEfSearch() {
        return this.efSearch;
    }

    /**
     * Set the efSearch property: The size of the dynamic list containing the nearest neighbors, which is used during
     * search time. Increasing this parameter may improve search results, at the expense of slower search. At a certain
     * point, increasing this parameter leads to diminishing returns.
     * 
     * @param efSearch the efSearch value to set.
     * @return the HnswParameters object itself.
     */
    public HnswParameters setEfSearch(Integer efSearch) {
        this.efSearch = efSearch;
        return this;
    }

    /**
     * Get the metric property: The similarity metric to use for vector comparisons.
     * 
     * @return the metric value.
     */
    public VectorSearchAlgorithmMetric getMetric() {
        return this.metric;
    }

    /**
     * Set the metric property: The similarity metric to use for vector comparisons.
     * 
     * @param metric the metric value to set.
     * @return the HnswParameters object itself.
     */
    public HnswParameters setMetric(VectorSearchAlgorithmMetric metric) {
        this.metric = metric;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("m", this.m);
        jsonWriter.writeNumberField("efConstruction", this.efConstruction);
        jsonWriter.writeNumberField("efSearch", this.efSearch);
        jsonWriter.writeStringField("metric", this.metric == null ? null : this.metric.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HnswParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HnswParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HnswParameters.
     */
    public static HnswParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HnswParameters deserializedHnswParameters = new HnswParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("m".equals(fieldName)) {
                    deserializedHnswParameters.m = reader.getNullable(JsonReader::getInt);
                } else if ("efConstruction".equals(fieldName)) {
                    deserializedHnswParameters.efConstruction = reader.getNullable(JsonReader::getInt);
                } else if ("efSearch".equals(fieldName)) {
                    deserializedHnswParameters.efSearch = reader.getNullable(JsonReader::getInt);
                } else if ("metric".equals(fieldName)) {
                    deserializedHnswParameters.metric = VectorSearchAlgorithmMetric.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHnswParameters;
        });
    }
}
