// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Defines behavior of the index projections in relation to the rest of the indexer.
 */
public final class IndexProjectionMode extends ExpandableStringEnum<IndexProjectionMode> {
    /**
     * The source document will be skipped from writing into the indexer's target index.
     */
    public static final IndexProjectionMode SKIP_INDEXING_PARENT_DOCUMENTS = fromString("skipIndexingParentDocuments");

    /**
     * The source document will be written into the indexer's target index. This is the default pattern.
     */
    public static final IndexProjectionMode INCLUDE_INDEXING_PARENT_DOCUMENTS
        = fromString("includeIndexingParentDocuments");

    /**
     * Creates a new instance of IndexProjectionMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IndexProjectionMode() {
    }

    /**
     * Creates or finds a IndexProjectionMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IndexProjectionMode.
     */
    public static IndexProjectionMode fromString(String name) {
        return fromString(name, IndexProjectionMode.class);
    }

    /**
     * Gets known IndexProjectionMode values.
     * 
     * @return known IndexProjectionMode values.
     */
    public static Collection<IndexProjectionMode> values() {
        return values(IndexProjectionMode.class);
    }
}
