// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Removes words that are too long or too short. This token filter is implemented using Apache Lucene.
 */
@Fluent
public final class LengthTokenFilter extends TokenFilter {
    /*
     * A URI fragment specifying the type of token filter.
     */
    private String odataType = "#Microsoft.Azure.Search.LengthTokenFilter";

    /*
     * The minimum length in characters. Default is 0. Maximum is 300. Must be less than the value of max.
     */
    private Integer minLength;

    /*
     * The maximum length in characters. Default and maximum is 300.
     */
    private Integer maxLength;

    /**
     * Creates an instance of LengthTokenFilter class.
     * 
     * @param name the name value to set.
     */
    public LengthTokenFilter(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     * 
     * @return the odataType value.
     */
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the minLength property: The minimum length in characters. Default is 0. Maximum is 300. Must be less than the
     * value of max.
     * 
     * @return the minLength value.
     */
    public Integer getMinLength() {
        return this.minLength;
    }

    /**
     * Set the minLength property: The minimum length in characters. Default is 0. Maximum is 300. Must be less than the
     * value of max.
     * 
     * @param minLength the minLength value to set.
     * @return the LengthTokenFilter object itself.
     */
    public LengthTokenFilter setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    /**
     * Get the maxLength property: The maximum length in characters. Default and maximum is 300.
     * 
     * @return the maxLength value.
     */
    public Integer getMaxLength() {
        return this.maxLength;
    }

    /**
     * Set the maxLength property: The maximum length in characters. Default and maximum is 300.
     * 
     * @param maxLength the maxLength value to set.
     * @return the LengthTokenFilter object itself.
     */
    public LengthTokenFilter setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("min", this.minLength);
        jsonWriter.writeNumberField("max", this.maxLength);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LengthTokenFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LengthTokenFilter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LengthTokenFilter.
     */
    public static LengthTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.LengthTokenFilter";
            Integer minLength = null;
            Integer maxLength = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("min".equals(fieldName)) {
                    minLength = reader.getNullable(JsonReader::getInt);
                } else if ("max".equals(fieldName)) {
                    maxLength = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                LengthTokenFilter deserializedLengthTokenFilter = new LengthTokenFilter(name);
                deserializedLengthTokenFilter.odataType = odataType;
                deserializedLengthTokenFilter.minLength = minLength;
                deserializedLengthTokenFilter.maxLength = maxLength;

                return deserializedLengthTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
