// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Base type for functions that can modify document scores during ranking.
 */
@Fluent
public class ScoringFunction implements JsonSerializable<ScoringFunction> {
    /*
     * Indicates the type of function to use. Valid values include magnitude, freshness, distance, and tag. The function
     * type must be lower case.
     */
    private String type = "ScoringFunction";

    /*
     * The name of the field used as input to the scoring function.
     */
    private final String fieldName;

    /*
     * A multiplier for the raw score. Must be a positive number not equal to 1.0.
     */
    private final double boost;

    /*
     * A value indicating how boosting will be interpolated across document scores; defaults to "Linear".
     */
    private ScoringFunctionInterpolation interpolation;

    /**
     * Creates an instance of ScoringFunction class.
     * 
     * @param fieldName the fieldName value to set.
     * @param boost the boost value to set.
     */
    public ScoringFunction(String fieldName, double boost) {
        this.fieldName = fieldName;
        this.boost = boost;
    }

    /**
     * Get the type property: Indicates the type of function to use. Valid values include magnitude, freshness,
     * distance, and tag. The function type must be lower case.
     * 
     * @return the type value.
     */
    public String getType() {
        return this.type;
    }

    /**
     * Get the fieldName property: The name of the field used as input to the scoring function.
     * 
     * @return the fieldName value.
     */
    public String getFieldName() {
        return this.fieldName;
    }

    /**
     * Get the boost property: A multiplier for the raw score. Must be a positive number not equal to 1.0.
     * 
     * @return the boost value.
     */
    public double getBoost() {
        return this.boost;
    }

    /**
     * Get the interpolation property: A value indicating how boosting will be interpolated across document scores;
     * defaults to "Linear".
     * 
     * @return the interpolation value.
     */
    public ScoringFunctionInterpolation getInterpolation() {
        return this.interpolation;
    }

    /**
     * Set the interpolation property: A value indicating how boosting will be interpolated across document scores;
     * defaults to "Linear".
     * 
     * @param interpolation the interpolation value to set.
     * @return the ScoringFunction object itself.
     */
    public ScoringFunction setInterpolation(ScoringFunctionInterpolation interpolation) {
        this.interpolation = interpolation;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fieldName", this.fieldName);
        jsonWriter.writeDoubleField("boost", this.boost);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("interpolation", this.interpolation == null ? null : this.interpolation.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScoringFunction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScoringFunction if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ScoringFunction.
     */
    public static ScoringFunction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String jsonFieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(jsonFieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("distance".equals(discriminatorValue)) {
                    return DistanceScoringFunction.fromJson(readerToUse.reset());
                } else if ("freshness".equals(discriminatorValue)) {
                    return FreshnessScoringFunction.fromJson(readerToUse.reset());
                } else if ("magnitude".equals(discriminatorValue)) {
                    return MagnitudeScoringFunction.fromJson(readerToUse.reset());
                } else if ("tag".equals(discriminatorValue)) {
                    return TagScoringFunction.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static ScoringFunction fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean fieldNameFound = false;
            String fieldName = null;
            boolean boostFound = false;
            double boost = 0.0;
            String type = null;
            ScoringFunctionInterpolation interpolation = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = reader.getFieldName();
                reader.nextToken();

                if ("fieldName".equals(jsonFieldName)) {
                    fieldName = reader.getString();
                    fieldNameFound = true;
                } else if ("boost".equals(jsonFieldName)) {
                    boost = reader.getDouble();
                    boostFound = true;
                } else if ("type".equals(jsonFieldName)) {
                    type = reader.getString();
                } else if ("interpolation".equals(jsonFieldName)) {
                    interpolation = ScoringFunctionInterpolation.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (fieldNameFound && boostFound) {
                ScoringFunction deserializedScoringFunction = new ScoringFunction(fieldName, boost);
                deserializedScoringFunction.type = type;
                deserializedScoringFunction.interpolation = interpolation;

                return deserializedScoringFunction;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!fieldNameFound) {
                missingProperties.add("fieldName");
            }
            if (!boostFound) {
                missingProperties.add("boost");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
