// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.AzureActiveDirectoryApplicationCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A customer-managed encryption key in Azure Key Vault. Keys that you create and manage can be used to encrypt or
 * decrypt data-at-rest, such as indexes and synonym maps.
 */
@Fluent
public final class SearchResourceEncryptionKey implements JsonSerializable<SearchResourceEncryptionKey> {

    /*
     * The name of your Azure Key Vault key to be used to encrypt your data at rest.
     */
    private final String keyName;

    /*
     * The version of your Azure Key Vault key to be used to encrypt your data at rest.
     */
    private final String keyVersion;

    /*
     * The URI of your Azure Key Vault, also referred to as DNS name, that contains the key to be used to encrypt your
     * data at rest. An example URI might be `https://my-keyvault-name.vault.azure.net`.
     */
    private final String vaultUrl;

    /*
     * Optional Azure Active Directory credentials used for accessing your Azure Key Vault. Not required if using
     * managed identity instead.
     */
    private AzureActiveDirectoryApplicationCredentials accessCredentials;

    /**
     * Creates an instance of SearchResourceEncryptionKey class.
     *
     * @param keyName the keyName value to set.
     * @param keyVersion the keyVersion value to set.
     * @param vaultUrl the vaultUrl value to set.
     */
    public SearchResourceEncryptionKey(String keyName, String keyVersion, String vaultUrl) {
        this.keyName = keyName;
        this.keyVersion = keyVersion;
        this.vaultUrl = vaultUrl;
    }

    /**
     * Get the keyName property: The name of your Azure Key Vault key to be used to encrypt your data at rest.
     *
     * @return the keyName value.
     */
    public String getKeyName() {
        return this.keyName;
    }

    /**
     * Get the keyVersion property: The version of your Azure Key Vault key to be used to encrypt your data at rest.
     *
     * @return the keyVersion value.
     */
    public String getKeyVersion() {
        return this.keyVersion;
    }

    /**
     * Get the vaultUrl property: The URI of your Azure Key Vault, also referred to as DNS name, that contains the key
     * to be used to encrypt your data at rest. An example URI might be `https://my-keyvault-name.vault.azure.net`.
     *
     * @return the vaultUrl value.
     */
    public String getVaultUrl() {
        return this.vaultUrl;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultKeyName", this.keyName);
        jsonWriter.writeStringField("keyVaultKeyVersion", this.keyVersion);
        jsonWriter.writeStringField("keyVaultUri", this.vaultUrl);
        jsonWriter.writeJsonField("accessCredentials", this.accessCredentials);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchResourceEncryptionKey from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchResourceEncryptionKey if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchResourceEncryptionKey.
     */
    public static SearchResourceEncryptionKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean keyNameFound = false;
            String keyName = null;
            boolean keyVersionFound = false;
            String keyVersion = null;
            boolean vaultUrlFound = false;
            String vaultUrl = null;
            AzureActiveDirectoryApplicationCredentials accessCredentials = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultKeyName".equals(fieldName)) {
                    keyName = reader.getString();
                    keyNameFound = true;
                } else if ("keyVaultKeyVersion".equals(fieldName)) {
                    keyVersion = reader.getString();
                    keyVersionFound = true;
                } else if ("keyVaultUri".equals(fieldName)) {
                    vaultUrl = reader.getString();
                    vaultUrlFound = true;
                } else if ("accessCredentials".equals(fieldName)) {
                    accessCredentials = AzureActiveDirectoryApplicationCredentials.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (keyNameFound && keyVersionFound && vaultUrlFound) {
                SearchResourceEncryptionKey deserializedSearchResourceEncryptionKey
                    = new SearchResourceEncryptionKey(keyName, keyVersion, vaultUrl);
                deserializedSearchResourceEncryptionKey.accessCredentials = accessCredentials;
                return deserializedSearchResourceEncryptionKey;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!keyNameFound) {
                missingProperties.add("keyVaultKeyName");
            }
            if (!keyVersionFound) {
                missingProperties.add("keyVaultKeyVersion");
            }
            if (!vaultUrlFound) {
                missingProperties.add("keyVaultUri");
            }
            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }

    /**
     * Get the applicationId property: An AAD Application ID that was granted the required access permissions to the
     * Azure Key Vault that is to be used when encrypting your data at rest. The Application ID should not be confused
     * with the Object ID for your AAD Application.
     *
     * @return the applicationId value.
     */
    public String getApplicationId() {
        return (this.accessCredentials == null) ? null : this.accessCredentials.getApplicationId();
    }

    /**
     * Set the applicationId property: An AAD Application ID that was granted the required access permissions to the
     * Azure Key Vault that is to be used when encrypting your data at rest. The Application ID should not be confused
     * with the Object ID for your AAD Application.
     *
     * @param applicationId the applicationId value to set.
     * @return the SearchResourceEncryptionKey object itself.
     */
    public SearchResourceEncryptionKey setApplicationId(String applicationId) {
        if (this.accessCredentials == null) {
            this.accessCredentials = new AzureActiveDirectoryApplicationCredentials();
        }
        this.accessCredentials.setApplicationId(applicationId);
        return this;
    }

    /**
     * Get the applicationSecret property: The authentication key of the specified AAD application.
     *
     * @return the applicationSecret value.
     */
    public String getApplicationSecret() {
        return (this.accessCredentials == null) ? null : this.accessCredentials.getApplicationSecret();
    }

    /**
     * Set the applicationSecret property: The authentication key of the specified AAD application.
     *
     * @param applicationSecret the applicationSecret value to set.
     * @return the SearchResourceEncryptionKey object itself.
     */
    public SearchResourceEncryptionKey setApplicationSecret(String applicationSecret) {
        if (this.accessCredentials == null) {
            this.accessCredentials = new AzureActiveDirectoryApplicationCredentials();
        }
        this.accessCredentials.setApplicationSecret(applicationSecret);
        return this;
    }
}
