// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A field that is used as part of the semantic configuration.
 */
@Immutable
public final class SemanticField implements JsonSerializable<SemanticField> {
    /*
     * The fieldName property.
     */
    private final String fieldName;

    /**
     * Creates an instance of SemanticField class.
     * 
     * @param fieldName the fieldName value to set.
     */
    public SemanticField(String fieldName) {
        this.fieldName = fieldName;
    }

    /**
     * Get the fieldName property: The fieldName property.
     * 
     * @return the fieldName value.
     */
    public String getFieldName() {
        return this.fieldName;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fieldName", this.fieldName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SemanticField from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SemanticField if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SemanticField.
     */
    public static SemanticField fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean fieldNameFound = false;
            String fieldName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = reader.getFieldName();
                reader.nextToken();

                if ("fieldName".equals(jsonFieldName)) {
                    fieldName = reader.getString();
                    fieldNameFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (fieldNameFound) {
                return new SemanticField(fieldName);
            }
            throw new IllegalStateException("Missing required property: fieldName");
        });
    }
}
