// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Defines parameters for a search index that influence semantic capabilities.
 */
@Fluent
public final class SemanticSearch implements JsonSerializable<SemanticSearch> {
    /*
     * Allows you to set the name of a default semantic configuration in your index, making it optional to pass it on as
     * a query parameter every time.
     */
    private String defaultConfigurationName;

    /*
     * The semantic configurations for the index.
     */
    private List<SemanticConfiguration> configurations;

    /**
     * Creates an instance of SemanticSearch class.
     */
    public SemanticSearch() {
    }

    /**
     * Get the defaultConfigurationName property: Allows you to set the name of a default semantic configuration in your
     * index, making it optional to pass it on as a query parameter every time.
     * 
     * @return the defaultConfigurationName value.
     */
    public String getDefaultConfigurationName() {
        return this.defaultConfigurationName;
    }

    /**
     * Set the defaultConfigurationName property: Allows you to set the name of a default semantic configuration in your
     * index, making it optional to pass it on as a query parameter every time.
     * 
     * @param defaultConfigurationName the defaultConfigurationName value to set.
     * @return the SemanticSearch object itself.
     */
    public SemanticSearch setDefaultConfigurationName(String defaultConfigurationName) {
        this.defaultConfigurationName = defaultConfigurationName;
        return this;
    }

    /**
     * Get the configurations property: The semantic configurations for the index.
     * 
     * @return the configurations value.
     */
    public List<SemanticConfiguration> getConfigurations() {
        return this.configurations;
    }

    /**
     * Set the configurations property: The semantic configurations for the index.
     * 
     * @param configurations the configurations value to set.
     * @return the SemanticSearch object itself.
     */
    public SemanticSearch setConfigurations(List<SemanticConfiguration> configurations) {
        this.configurations = configurations;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultConfiguration", this.defaultConfigurationName);
        jsonWriter.writeArrayField("configurations", this.configurations,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SemanticSearch from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SemanticSearch if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SemanticSearch.
     */
    public static SemanticSearch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SemanticSearch deserializedSemanticSearch = new SemanticSearch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defaultConfiguration".equals(fieldName)) {
                    deserializedSemanticSearch.defaultConfigurationName = reader.getString();
                } else if ("configurations".equals(fieldName)) {
                    List<SemanticConfiguration> configurations
                        = reader.readArray(reader1 -> SemanticConfiguration.fromJson(reader1));
                    deserializedSemanticSearch.configurations = configurations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSemanticSearch;
        });
    }
}
