// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The strings indicating what visual feature types to return.
 */
public final class VisualFeature extends ExpandableStringEnum<VisualFeature> {
    /**
     * Visual features recognized as adult persons.
     */
    public static final VisualFeature ADULT = fromString("adult");

    /**
     * Visual features recognized as commercial brands.
     */
    public static final VisualFeature BRANDS = fromString("brands");

    /**
     * Categories.
     */
    public static final VisualFeature CATEGORIES = fromString("categories");

    /**
     * Description.
     */
    public static final VisualFeature DESCRIPTION = fromString("description");

    /**
     * Visual features recognized as people faces.
     */
    public static final VisualFeature FACES = fromString("faces");

    /**
     * Visual features recognized as objects.
     */
    public static final VisualFeature OBJECTS = fromString("objects");

    /**
     * Tags.
     */
    public static final VisualFeature TAGS = fromString("tags");

    /**
     * Creates a new instance of VisualFeature value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VisualFeature() {
    }

    /**
     * Creates or finds a VisualFeature from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VisualFeature.
     */
    public static VisualFeature fromString(String name) {
        return fromString(name, VisualFeature.class);
    }

    /**
     * Gets known VisualFeature values.
     * 
     * @return known VisualFeature values.
     */
    public static Collection<VisualFeature> values() {
        return values(VisualFeature.class);
    }
}
