// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Arrays;

/**
 * Parameter group.
 */
@Fluent
public final class SuggestOptions implements JsonSerializable<SuggestOptions> {

    /*
     * An OData expression that filters the documents considered for suggestions.
     */
    private String filter;

    /*
     * A value indicating whether to use fuzzy matching for the suggestions query. Default is false. When set to true,
     * the query will find terms even if there's a substituted or missing character in the search text. While this
     * provides a better experience in some scenarios, it comes at a performance cost as fuzzy suggestions queries are
     * slower and consume more resources.
     */
    private Boolean useFuzzyMatching;

    /*
     * A string tag that is appended to hit highlights. Must be set with highlightPreTag. If omitted, hit highlighting
     * of suggestions is disabled.
     */
    private String highlightPostTag;

    /*
     * A string tag that is prepended to hit highlights. Must be set with highlightPostTag. If omitted, hit highlighting
     * of suggestions is disabled.
     */
    private String highlightPreTag;

    /*
     * A number between 0 and 100 indicating the percentage of the index that must be covered by a suggestions query in
     * order for the query to be reported as a success. This parameter can be useful for ensuring search availability
     * even for services with only one replica. The default is 80.
     */
    private Double minimumCoverage;

    /*
     * The list of OData $orderby expressions by which to sort the results. Each expression can be either a field name
     * or a call to either the geo.distance() or the search.score() functions. Each expression can be followed by asc to
     * indicate ascending, or desc to indicate descending. The default is ascending order. Ties will be broken by the
     * match scores of documents. If no $orderby is specified, the default sort order is descending by document match
     * score. There can be at most 32 $orderby clauses.
     */
    private List<String> orderBy;

    /*
     * The list of field names to search for the specified search text. Target fields must be included in the specified
     * suggester.
     */
    private List<String> searchFields;

    /*
     * The list of fields to retrieve. If unspecified, only the key field will be included in the results.
     */
    private List<String> select;

    /*
     * The number of suggestions to retrieve. The value must be a number between 1 and 100. The default is 5.
     */
    private Integer top;

    /**
     * Creates an instance of SuggestOptions class.
     */
    public SuggestOptions() {
    }

    /**
     * Get the filter property: An OData expression that filters the documents considered for suggestions.
     *
     * @return the filter value.
     */
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: An OData expression that filters the documents considered for suggestions.
     *
     * @param filter the filter value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the useFuzzyMatching property: A value indicating whether to use fuzzy matching for the suggestions query.
     * Default is false. When set to true, the query will find terms even if there's a substituted or missing character
     * in the search text. While this provides a better experience in some scenarios, it comes at a performance cost as
     * fuzzy suggestions queries are slower and consume more resources.
     *
     * @return the useFuzzyMatching value.
     */
    public Boolean useFuzzyMatching() {
        return this.useFuzzyMatching;
    }

    /**
     * Set the useFuzzyMatching property: A value indicating whether to use fuzzy matching for the suggestions query.
     * Default is false. When set to true, the query will find terms even if there's a substituted or missing character
     * in the search text. While this provides a better experience in some scenarios, it comes at a performance cost as
     * fuzzy suggestions queries are slower and consume more resources.
     *
     * @param useFuzzyMatching the useFuzzyMatching value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setUseFuzzyMatching(Boolean useFuzzyMatching) {
        this.useFuzzyMatching = useFuzzyMatching;
        return this;
    }

    /**
     * Get the highlightPostTag property: A string tag that is appended to hit highlights. Must be set with
     * highlightPreTag. If omitted, hit highlighting of suggestions is disabled.
     *
     * @return the highlightPostTag value.
     */
    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    /**
     * Set the highlightPostTag property: A string tag that is appended to hit highlights. Must be set with
     * highlightPreTag. If omitted, hit highlighting of suggestions is disabled.
     *
     * @param highlightPostTag the highlightPostTag value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    /**
     * Get the highlightPreTag property: A string tag that is prepended to hit highlights. Must be set with
     * highlightPostTag. If omitted, hit highlighting of suggestions is disabled.
     *
     * @return the highlightPreTag value.
     */
    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    /**
     * Set the highlightPreTag property: A string tag that is prepended to hit highlights. Must be set with
     * highlightPostTag. If omitted, hit highlighting of suggestions is disabled.
     *
     * @param highlightPreTag the highlightPreTag value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    /**
     * Get the minimumCoverage property: A number between 0 and 100 indicating the percentage of the index that must be
     * covered by a suggestions query in order for the query to be reported as a success. This parameter can be useful
     * for ensuring search availability even for services with only one replica. The default is 80.
     *
     * @return the minimumCoverage value.
     */
    public Double getMinimumCoverage() {
        return this.minimumCoverage;
    }

    /**
     * Set the minimumCoverage property: A number between 0 and 100 indicating the percentage of the index that must be
     * covered by a suggestions query in order for the query to be reported as a success. This parameter can be useful
     * for ensuring search availability even for services with only one replica. The default is 80.
     *
     * @param minimumCoverage the minimumCoverage value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setMinimumCoverage(Double minimumCoverage) {
        this.minimumCoverage = minimumCoverage;
        return this;
    }

    /**
     * Get the orderBy property: The list of OData $orderby expressions by which to sort the results. Each expression
     * can be either a field name or a call to either the geo.distance() or the search.score() functions. Each
     * expression can be followed by asc to indicate ascending, or desc to indicate descending. The default is ascending
     * order. Ties will be broken by the match scores of documents. If no $orderby is specified, the default sort order
     * is descending by document match score. There can be at most 32 $orderby clauses.
     *
     * @return the orderBy value.
     */
    public List<String> getOrderBy() {
        return this.orderBy;
    }

    /**
     * Set the orderBy property: The list of OData $orderby expressions by which to sort the results. Each expression
     * can be either a field name or a call to either the geo.distance() or the search.score() functions. Each
     * expression can be followed by asc to indicate ascending, or desc to indicate descending. The default is ascending
     * order. Ties will be broken by the match scores of documents. If no $orderby is specified, the default sort order
     * is descending by document match score. There can be at most 32 $orderby clauses.
     *
     * @param orderBy the orderBy value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setOrderBy(List<String> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    /**
     * Get the searchFields property: The list of field names to search for the specified search text. Target fields
     * must be included in the specified suggester.
     *
     * @return the searchFields value.
     */
    public List<String> getSearchFields() {
        return this.searchFields;
    }

    /**
     * Set the searchFields property: The list of field names to search for the specified search text. Target fields
     * must be included in the specified suggester.
     *
     * @param searchFields the searchFields value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setSearchFields(List<String> searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    /**
     * Get the select property: The list of fields to retrieve. If unspecified, only the key field will be included in
     * the results.
     *
     * @return the select value.
     */
    public List<String> getSelect() {
        return this.select;
    }

    /**
     * Set the select property: The list of fields to retrieve. If unspecified, only the key field will be included in
     * the results.
     *
     * @param select the select value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setSelect(List<String> select) {
        this.select = select;
        return this;
    }

    /**
     * Get the top property: The number of suggestions to retrieve. The value must be a number between 1 and 100. The
     * default is 5.
     *
     * @return the top value.
     */
    public Integer getTop() {
        return this.top;
    }

    /**
     * Set the top property: The number of suggestions to retrieve. The value must be a number between 1 and 100. The
     * default is 5.
     *
     * @param top the top value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setTop(Integer top) {
        this.top = top;
        return this;
    }

    /**
     * Set the orderBy property: The list of OData $orderby expressions by which to sort the results. Each expression
     * can be either a field name or a call to either the geo.distance() or the search.score() functions. Each
     * expression can be followed by asc to indicate ascending, or desc to indicate descending. The default is ascending
     * order. Ties will be broken by the match scores of documents. If no $orderby is specified, the default sort order
     * is descending by document match score. There can be at most 32 $orderby clauses.
     *
     * @param orderBy the orderBy value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setOrderBy(String... orderBy) {
        this.orderBy = (orderBy == null) ? null : Arrays.asList(orderBy);
        return this;
    }

    /**
     * Set the searchFields property: The list of field names to search for the specified search text. Target fields
     * must be included in the specified suggester.
     *
     * @param searchFields the searchFields value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setSearchFields(String... searchFields) {
        this.searchFields = (searchFields == null) ? null : Arrays.asList(searchFields);
        return this;
    }

    /**
     * Set the select property: The list of fields to retrieve. If unspecified, only the key field will be included in
     * the results.
     *
     * @param select the select value to set.
     * @return the SuggestOptions object itself.
     */
    public SuggestOptions setSelect(String... select) {
        this.select = (select == null) ? null : Arrays.asList(select);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("$filter", this.filter);
        jsonWriter.writeBooleanField("UseFuzzyMatching", this.useFuzzyMatching);
        jsonWriter.writeStringField("highlightPostTag", this.highlightPostTag);
        jsonWriter.writeStringField("highlightPreTag", this.highlightPreTag);
        jsonWriter.writeNumberField("minimumCoverage", this.minimumCoverage);
        jsonWriter.writeArrayField("OrderBy", this.orderBy, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("searchFields", this.searchFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("$select", this.select, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("$top", this.top);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SuggestOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SuggestOptions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SuggestOptions.
     */
    public static SuggestOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SuggestOptions deserializedSuggestOptions = new SuggestOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("$filter".equals(fieldName)) {
                    deserializedSuggestOptions.filter = reader.getString();
                } else if ("UseFuzzyMatching".equals(fieldName)) {
                    deserializedSuggestOptions.useFuzzyMatching = reader.getNullable(JsonReader::getBoolean);
                } else if ("highlightPostTag".equals(fieldName)) {
                    deserializedSuggestOptions.highlightPostTag = reader.getString();
                } else if ("highlightPreTag".equals(fieldName)) {
                    deserializedSuggestOptions.highlightPreTag = reader.getString();
                } else if ("minimumCoverage".equals(fieldName)) {
                    deserializedSuggestOptions.minimumCoverage = reader.getNullable(JsonReader::getDouble);
                } else if ("OrderBy".equals(fieldName)) {
                    List<String> orderBy = reader.readArray(reader1 -> reader1.getString());
                    deserializedSuggestOptions.orderBy = orderBy;
                } else if ("searchFields".equals(fieldName)) {
                    List<String> searchFields = reader.readArray(reader1 -> reader1.getString());
                    deserializedSuggestOptions.searchFields = searchFields;
                } else if ("$select".equals(fieldName)) {
                    List<String> select = reader.readArray(reader1 -> reader1.getString());
                    deserializedSuggestOptions.select = select;
                } else if ("$top".equals(fieldName)) {
                    deserializedSuggestOptions.top = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedSuggestOptions;
        });
    }
}
