// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Determines whether or not filters are applied before or after the vector search is performed.
 */
public final class VectorFilterMode extends ExpandableStringEnum<VectorFilterMode> {
    /**
     * The filter will be applied after the candidate set of vector results is returned. Depending on the filter
     * selectivity, this can result in fewer results than requested by the parameter 'k'.
     */
    public static final VectorFilterMode POST_FILTER = fromString("postFilter");

    /**
     * The filter will be applied before the search query.
     */
    public static final VectorFilterMode PRE_FILTER = fromString("preFilter");

    /**
     * Creates a new instance of VectorFilterMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VectorFilterMode() {
    }

    /**
     * Creates or finds a VectorFilterMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VectorFilterMode.
     */
    public static VectorFilterMode fromString(String name) {
        return fromString(name, VectorFilterMode.class);
    }

    /**
     * Gets known VectorFilterMode values.
     * 
     * @return known VectorFilterMode values.
     */
    public static Collection<VectorFilterMode> values() {
        return values(VectorFilterMode.class);
    }
}
