// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The query parameters for vector and hybrid search queries.
 */
@Fluent
public class VectorQuery implements JsonSerializable<VectorQuery> {

    /*
     * The kind of vector query being performed.
     */
    private VectorQueryKind kind = VectorQueryKind.fromString("VectorQuery");

    /*
     * Number of nearest neighbors to return as top hits.
     */
    private Integer kNearestNeighborsCount;

    /*
     * Vector Fields of type Collection(Edm.Single) to be included in the vector searched.
     */
    private String fields;

    /*
     * When true, triggers an exhaustive k-nearest neighbor search across all vectors within the vector index. Useful
     * for scenarios where exact matches are critical, such as determining ground truth values.
     */
    private Boolean exhaustive;

    /*
     * Oversampling factor. Minimum value is 1. It overrides the 'defaultOversampling' parameter configured in the index
     * definition. It can be set only when 'rerankWithOriginalVectors' is true. This parameter is only permitted when a
     * compression method is used on the underlying vector field.
     */
    private Double oversampling;

    /*
     * Relative weight of the vector query when compared to other vector query and/or the text query within the same
     * search request. This value is used when combining the results of multiple ranking lists produced by the different
     * vector queries and/or the results retrieved through the text query. The higher the weight, the higher the
     * documents that matched that query will be in the final ranking. Default is 1.0 and the value needs to be a
     * positive number larger than zero.
     */
    private Float weight;

    /**
     * Creates an instance of VectorQuery class.
     */
    public VectorQuery() {
    }

    /**
     * Get the kind property: The kind of vector query being performed.
     *
     * @return the kind value.
     */
    public VectorQueryKind getKind() {
        return this.kind;
    }

    /**
     * Get the kNearestNeighborsCount property: Number of nearest neighbors to return as top hits.
     *
     * @return the kNearestNeighborsCount value.
     */
    public Integer getKNearestNeighborsCount() {
        return this.kNearestNeighborsCount;
    }

    /**
     * Set the kNearestNeighborsCount property: Number of nearest neighbors to return as top hits.
     *
     * @param kNearestNeighborsCount the kNearestNeighborsCount value to set.
     * @return the VectorQuery object itself.
     */
    public VectorQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        this.kNearestNeighborsCount = kNearestNeighborsCount;
        return this;
    }

    /**
     * Get the fields property: Vector Fields of type Collection(Edm.Single) to be included in the vector searched.
     *
     * @return the fields value.
     */
    public String getFields() {
        return this.fields;
    }

    /**
     * Set the fields property: Vector Fields of type Collection(Edm.Single) to be included in the vector searched.
     *
     * @param fields the fields value to set.
     * @return the VectorQuery object itself.
     */
    public VectorQuery setFields(String... fields) {
        this.fields = (fields == null) ? null : String.join(",", fields);
        return this;
    }

    /**
     * Get the exhaustive property: When true, triggers an exhaustive k-nearest neighbor search across all vectors
     * within the vector index. Useful for scenarios where exact matches are critical, such as determining ground truth
     * values.
     *
     * @return the exhaustive value.
     */
    public Boolean isExhaustive() {
        return this.exhaustive;
    }

    /**
     * Set the exhaustive property: When true, triggers an exhaustive k-nearest neighbor search across all vectors
     * within the vector index. Useful for scenarios where exact matches are critical, such as determining ground truth
     * values.
     *
     * @param exhaustive the exhaustive value to set.
     * @return the VectorQuery object itself.
     */
    public VectorQuery setExhaustive(Boolean exhaustive) {
        this.exhaustive = exhaustive;
        return this;
    }

    /**
     * Get the oversampling property: Oversampling factor. Minimum value is 1. It overrides the 'defaultOversampling'
     * parameter configured in the index definition. It can be set only when 'rerankWithOriginalVectors' is true. This
     * parameter is only permitted when a compression method is used on the underlying vector field.
     *
     * @return the oversampling value.
     */
    public Double getOversampling() {
        return this.oversampling;
    }

    /**
     * Set the oversampling property: Oversampling factor. Minimum value is 1. It overrides the 'defaultOversampling'
     * parameter configured in the index definition. It can be set only when 'rerankWithOriginalVectors' is true. This
     * parameter is only permitted when a compression method is used on the underlying vector field.
     *
     * @param oversampling the oversampling value to set.
     * @return the VectorQuery object itself.
     */
    public VectorQuery setOversampling(Double oversampling) {
        this.oversampling = oversampling;
        return this;
    }

    /**
     * Get the weight property: Relative weight of the vector query when compared to other vector query and/or the text
     * query within the same search request. This value is used when combining the results of multiple ranking lists
     * produced by the different vector queries and/or the results retrieved through the text query. The higher the
     * weight, the higher the documents that matched that query will be in the final ranking. Default is 1.0 and the
     * value needs to be a positive number larger than zero.
     *
     * @return the weight value.
     */
    public Float getWeight() {
        return this.weight;
    }

    /**
     * Set the weight property: Relative weight of the vector query when compared to other vector query and/or the text
     * query within the same search request. This value is used when combining the results of multiple ranking lists
     * produced by the different vector queries and/or the results retrieved through the text query. The higher the
     * weight, the higher the documents that matched that query will be in the final ranking. Default is 1.0 and the
     * value needs to be a positive number larger than zero.
     *
     * @param weight the weight value to set.
     * @return the VectorQuery object itself.
     */
    public VectorQuery setWeight(Float weight) {
        this.weight = weight;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeNumberField("k", this.kNearestNeighborsCount);
        jsonWriter.writeStringField("fields", this.fields);
        jsonWriter.writeBooleanField("exhaustive", this.exhaustive);
        jsonWriter.writeNumberField("oversampling", this.oversampling);
        jsonWriter.writeNumberField("weight", this.weight);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorQuery from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorQuery if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VectorQuery.
     */
    public static VectorQuery fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("text".equals(discriminatorValue)) {
                    return VectorizableTextQuery.fromJson(readerToUse.reset());
                } else if ("vector".equals(discriminatorValue)) {
                    return VectorizedQuery.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static VectorQuery fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorQuery deserializedVectorQuery = new VectorQuery();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedVectorQuery.kind = VectorQueryKind.fromString(reader.getString());
                } else if ("k".equals(fieldName)) {
                    deserializedVectorQuery.kNearestNeighborsCount = reader.getNullable(JsonReader::getInt);
                } else if ("fields".equals(fieldName)) {
                    deserializedVectorQuery.fields = reader.getString();
                } else if ("exhaustive".equals(fieldName)) {
                    deserializedVectorQuery.exhaustive = reader.getNullable(JsonReader::getBoolean);
                } else if ("oversampling".equals(fieldName)) {
                    deserializedVectorQuery.oversampling = reader.getNullable(JsonReader::getDouble);
                } else if ("weight".equals(fieldName)) {
                    deserializedVectorQuery.weight = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedVectorQuery;
        });
    }
}
