/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SynonymMap;
import java.io.IOException;
import java.util.List;

public final class ListSynonymMapsResult
implements JsonSerializable<ListSynonymMapsResult> {
    private final List<SynonymMap> synonymMaps;

    public ListSynonymMapsResult(List<SynonymMap> synonymMaps) {
        this.synonymMaps = synonymMaps;
    }

    public List<SynonymMap> getSynonymMaps() {
        return this.synonymMaps;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ListSynonymMapsResult fromJson(JsonReader jsonReader) throws IOException {
        return (ListSynonymMapsResult)jsonReader.readObject(reader -> {
            boolean synonymMapsFound = false;
            List synonymMaps = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    synonymMaps = reader.readArray(reader1 -> SynonymMap.fromJson(reader1));
                    synonymMapsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (synonymMapsFound) {
                return new ListSynonymMapsResult(synonymMaps);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}

