/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class NGramTokenFilterV1
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.NGramTokenFilter";
    private Integer minGram;
    private Integer maxGram;

    public NGramTokenFilterV1(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Integer getMinGram() {
        return this.minGram;
    }

    public NGramTokenFilterV1 setMinGram(Integer minGram) {
        this.minGram = minGram;
        return this;
    }

    public Integer getMaxGram() {
        return this.maxGram;
    }

    public NGramTokenFilterV1 setMaxGram(Integer maxGram) {
        this.maxGram = maxGram;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("minGram", (Number)this.minGram);
        jsonWriter.writeNumberField("maxGram", (Number)this.maxGram);
        return jsonWriter.writeEndObject();
    }

    public static NGramTokenFilterV1 fromJson(JsonReader jsonReader) throws IOException {
        return (NGramTokenFilterV1)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.NGramTokenFilter";
            Integer minGram = null;
            Integer maxGram = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("minGram".equals(fieldName)) {
                    minGram = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxGram".equals(fieldName)) {
                    maxGram = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                NGramTokenFilterV1 deserializedNGramTokenFilterV1 = new NGramTokenFilterV1(name);
                deserializedNGramTokenFilterV1.odataType = odataType;
                deserializedNGramTokenFilterV1.minGram = minGram;
                deserializedNGramTokenFilterV1.maxGram = maxGram;
                return deserializedNGramTokenFilterV1;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

