/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class DistanceScoringParameters
implements JsonSerializable<DistanceScoringParameters> {
    private final String referencePointParameter;
    private final double boostingDistance;

    public DistanceScoringParameters(String referencePointParameter, double boostingDistance) {
        this.referencePointParameter = referencePointParameter;
        this.boostingDistance = boostingDistance;
    }

    public String getReferencePointParameter() {
        return this.referencePointParameter;
    }

    public double getBoostingDistance() {
        return this.boostingDistance;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("referencePointParameter", this.referencePointParameter);
        jsonWriter.writeDoubleField("boostingDistance", this.boostingDistance);
        return jsonWriter.writeEndObject();
    }

    public static DistanceScoringParameters fromJson(JsonReader jsonReader) throws IOException {
        return (DistanceScoringParameters)jsonReader.readObject(reader -> {
            boolean referencePointParameterFound = false;
            String referencePointParameter = null;
            boolean boostingDistanceFound = false;
            double boostingDistance = 0.0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("referencePointParameter".equals(fieldName)) {
                    referencePointParameter = reader.getString();
                    referencePointParameterFound = true;
                    continue;
                }
                if ("boostingDistance".equals(fieldName)) {
                    boostingDistance = reader.getDouble();
                    boostingDistanceFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (referencePointParameterFound && boostingDistanceFound) {
                return new DistanceScoringParameters(referencePointParameter, boostingDistance);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!referencePointParameterFound) {
                missingProperties.add("referencePointParameter");
            }
            if (!boostingDistanceFound) {
                missingProperties.add("boostingDistance");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

