/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.EdgeNGramTokenFilterV1;
import com.azure.search.documents.indexes.implementation.models.EdgeNGramTokenFilterV2;
import com.azure.search.documents.indexes.implementation.models.NGramTokenFilterV1;
import com.azure.search.documents.indexes.implementation.models.NGramTokenFilterV2;
import com.azure.search.documents.indexes.models.AsciiFoldingTokenFilter;
import com.azure.search.documents.indexes.models.CjkBigramTokenFilter;
import com.azure.search.documents.indexes.models.CommonGramTokenFilter;
import com.azure.search.documents.indexes.models.DictionaryDecompounderTokenFilter;
import com.azure.search.documents.indexes.models.ElisionTokenFilter;
import com.azure.search.documents.indexes.models.KeepTokenFilter;
import com.azure.search.documents.indexes.models.KeywordMarkerTokenFilter;
import com.azure.search.documents.indexes.models.LengthTokenFilter;
import com.azure.search.documents.indexes.models.LimitTokenFilter;
import com.azure.search.documents.indexes.models.PatternCaptureTokenFilter;
import com.azure.search.documents.indexes.models.PatternReplaceTokenFilter;
import com.azure.search.documents.indexes.models.PhoneticTokenFilter;
import com.azure.search.documents.indexes.models.ShingleTokenFilter;
import com.azure.search.documents.indexes.models.SnowballTokenFilter;
import com.azure.search.documents.indexes.models.StemmerOverrideTokenFilter;
import com.azure.search.documents.indexes.models.StemmerTokenFilter;
import com.azure.search.documents.indexes.models.StopwordsTokenFilter;
import com.azure.search.documents.indexes.models.SynonymTokenFilter;
import com.azure.search.documents.indexes.models.TruncateTokenFilter;
import com.azure.search.documents.indexes.models.UniqueTokenFilter;
import com.azure.search.documents.indexes.models.WordDelimiterTokenFilter;
import java.io.IOException;

public class TokenFilter
implements JsonSerializable<TokenFilter> {
    private String odataType = "TokenFilter";
    private final String name;

    public TokenFilter(String name) {
        this.name = name;
    }

    public String getOdataType() {
        return this.odataType;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static TokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (TokenFilter)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                TokenFilter tokenFilter;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Azure.Search.AsciiFoldingTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = AsciiFoldingTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.CjkBigramTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = CjkBigramTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.CommonGramTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = CommonGramTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = DictionaryDecompounderTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.EdgeNGramTokenFilterV2".equals(discriminatorValue)) {
                    tokenFilter = EdgeNGramTokenFilterV2.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.ElisionTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = ElisionTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.KeepTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = KeepTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.KeywordMarkerTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = KeywordMarkerTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.LengthTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = LengthTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.LimitTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = LimitTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.NGramTokenFilterV2".equals(discriminatorValue)) {
                    tokenFilter = NGramTokenFilterV2.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.PatternCaptureTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = PatternCaptureTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.PatternReplaceTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = PatternReplaceTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.PhoneticTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = PhoneticTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.ShingleTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = ShingleTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.SnowballTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = SnowballTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.StemmerTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = StemmerTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.StemmerOverrideTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = StemmerOverrideTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.StopwordsTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = StopwordsTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.SynonymTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = SynonymTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.TruncateTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = TruncateTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.UniqueTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = UniqueTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.WordDelimiterTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = WordDelimiterTokenFilter.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.EdgeNGramTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = EdgeNGramTokenFilterV1.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                if ("#Microsoft.Azure.Search.NGramTokenFilter".equals(discriminatorValue)) {
                    tokenFilter = NGramTokenFilterV1.fromJson(readerToUse.reset());
                    return tokenFilter;
                }
                tokenFilter = TokenFilter.fromJsonKnownDiscriminator(readerToUse.reset());
                return tokenFilter;
            }
        });
    }

    static TokenFilter fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (TokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                TokenFilter deserializedTokenFilter = new TokenFilter(name);
                deserializedTokenFilter.odataType = odataType;
                return deserializedTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

