// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

/**
 * The quick query format type.
 */
public enum QueryFormatType {
    /**
     * Enum value delimited.
     */
    DELIMITED("delimited"),

    /**
     * Enum value json.
     */
    JSON("json"),

    /**
     * Enum value arrow.
     */
    ARROW("arrow"),

    /**
     * Enum value parquet.
     */
    PARQUET("parquet");

    /**
     * The actual serialized value for a QueryFormatType instance.
     */
    private final String value;

    QueryFormatType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a QueryFormatType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed QueryFormatType object, or null if unable to parse.
     */
    public static QueryFormatType fromString(String value) {
        if (value == null) {
            return null;
        }
        QueryFormatType[] items = QueryFormatType.values();
        for (QueryFormatType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
