/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.util;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.AzureSasCredentialPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.BuilderUtils;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.credentials.CredentialValidator;
import com.azure.storage.common.policy.MetadataValidationPolicy;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.ResponseValidationPolicyBuilder;
import com.azure.storage.common.policy.ScrubEtagPolicy;
import com.azure.storage.common.policy.StorageSharedKeyCredentialPolicy;
import com.azure.storage.common.sas.CommonSasQueryParameters;
import com.azure.storage.queue.implementation.util.QueueHeadersAndQueryParameters;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class BuilderHelper {
    private static final String CLIENT_NAME;
    private static final String CLIENT_VERSION;

    public static boolean determineAuthorityIsIpStyle(String authority) throws MalformedURLException {
        return new URL("http://" + authority).getPort() != -1;
    }

    public static QueueUrlParts parseEndpoint(String endpoint, ClientLogger logger) {
        Objects.requireNonNull(endpoint);
        try {
            URL url = new URL(endpoint);
            QueueUrlParts parts = new QueueUrlParts().setScheme(url.getProtocol());
            if (BuilderHelper.determineAuthorityIsIpStyle(url.getAuthority())) {
                String path = url.getPath();
                if (!CoreUtils.isNullOrEmpty((CharSequence)path) && path.charAt(0) == '/') {
                    path = path.substring(1);
                }
                String[] pathPieces = path.split("/", 2);
                parts.setAccountName(pathPieces[0]);
                if (pathPieces.length == 2) {
                    parts.setQueueName(pathPieces[1]);
                }
                parts.setEndpoint(url.getProtocol() + "://" + url.getAuthority() + "/" + parts.getAccountName());
            } else {
                String host = url.getHost();
                String accountName = null;
                if (!CoreUtils.isNullOrEmpty((CharSequence)host)) {
                    int accountNameIndex = host.indexOf(46);
                    accountName = accountNameIndex == -1 ? host : host.substring(0, accountNameIndex);
                }
                parts.setAccountName(accountName);
                String[] pathSegments = url.getPath().split("/", 2);
                if (pathSegments.length == 2 && !CoreUtils.isNullOrEmpty((CharSequence)pathSegments[1])) {
                    parts.setQueueName(pathSegments[1]);
                }
                parts.setEndpoint(url.getProtocol() + "://" + url.getAuthority());
            }
            String sasToken = new CommonSasQueryParameters(SasImplUtils.parseQueryString((String)url.getQuery()), false).encode();
            if (!CoreUtils.isNullOrEmpty((CharSequence)sasToken)) {
                parts.setSasToken(sasToken);
            }
            return parts;
        }
        catch (MalformedURLException ex) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Storage Queue endpoint url is malformed.", ex));
        }
    }

    public static HttpPipeline buildPipeline(StorageSharedKeyCredential storageSharedKeyCredential, TokenCredential tokenCredential, AzureSasCredential azureSasCredential, String sasToken, String endpoint, RequestRetryOptions retryOptions, RetryOptions coreRetryOptions, HttpLogOptions logOptions, ClientOptions clientOptions, HttpClient httpClient, List<HttpPipelinePolicy> perCallPolicies, List<HttpPipelinePolicy> perRetryPolicies, Configuration configuration, ClientLogger logger) {
        Object credentialPolicy;
        CredentialValidator.validateSingleCredentialIsPresent((StorageSharedKeyCredential)storageSharedKeyCredential, (TokenCredential)tokenCredential, (AzureSasCredential)azureSasCredential, (String)sasToken, (ClientLogger)logger);
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(BuilderHelper.getUserAgentPolicy(configuration, logOptions, clientOptions));
        policies.add(new RequestIdPolicy());
        policies.addAll(perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(BuilderUtils.createRetryPolicy((RequestRetryOptions)retryOptions, (RetryOptions)coreRetryOptions, (ClientLogger)logger));
        policies.add(new AddDatePolicy());
        HttpHeaders headers = CoreUtils.createHttpHeadersFromClientOptions((ClientOptions)clientOptions);
        if (headers != null) {
            policies.add(new AddHeadersPolicy(headers));
        }
        policies.add(new MetadataValidationPolicy());
        if (storageSharedKeyCredential != null) {
            credentialPolicy = new StorageSharedKeyCredentialPolicy(storageSharedKeyCredential);
        } else if (tokenCredential != null) {
            BuilderHelper.httpsValidation(tokenCredential, "bearer token", endpoint, logger);
            credentialPolicy = new BearerTokenAuthenticationPolicy(tokenCredential, new String[]{"https://storage.azure.com/.default"});
        } else {
            credentialPolicy = azureSasCredential != null ? new AzureSasCredentialPolicy(azureSasCredential, false) : (sasToken != null ? new AzureSasCredentialPolicy(new AzureSasCredential(sasToken), false) : null);
        }
        if (credentialPolicy != null) {
            policies.add(credentialPolicy);
        }
        policies.addAll(perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(BuilderHelper.getResponseValidationPolicy());
        policies.add(new HttpLoggingPolicy(logOptions));
        policies.add(new ScrubEtagPolicy());
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).clientOptions(clientOptions).tracer(BuilderHelper.createTracer(clientOptions)).build();
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        HttpLogOptions defaultOptions = new HttpLogOptions();
        QueueHeadersAndQueryParameters.getQueueHeaders().forEach(arg_0 -> ((HttpLogOptions)defaultOptions).addAllowedHeaderName(arg_0));
        QueueHeadersAndQueryParameters.getQueueQueryParameters().forEach(arg_0 -> ((HttpLogOptions)defaultOptions).addAllowedQueryParamName(arg_0));
        return defaultOptions;
    }

    private static UserAgentPolicy getUserAgentPolicy(Configuration configuration, HttpLogOptions logOptions, ClientOptions clientOptions) {
        configuration = configuration == null ? Configuration.NONE : configuration;
        String applicationId = CoreUtils.getApplicationId((ClientOptions)clientOptions, (HttpLogOptions)logOptions);
        return new UserAgentPolicy(applicationId, CLIENT_NAME, CLIENT_VERSION, configuration);
    }

    private static HttpPipelinePolicy getResponseValidationPolicy() {
        return new ResponseValidationPolicyBuilder().addOptionalEcho("x-ms-client-request-id").build();
    }

    public static void httpsValidation(Object objectToCheck, String objectName, String endpoint, ClientLogger logger) {
        if (objectToCheck != null && !BuilderHelper.parseEndpoint(endpoint, logger).getScheme().equals("https")) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Using a(n) " + objectName + " requires https"));
        }
    }

    private static Tracer createTracer(ClientOptions clientOptions) {
        TracingOptions tracingOptions = clientOptions == null ? null : clientOptions.getTracingOptions();
        return TracerProvider.getDefaultProvider().createTracer(CLIENT_NAME, CLIENT_VERSION, "Microsoft.Storage", tracingOptions);
    }

    static {
        Map properties = CoreUtils.getProperties((String)"azure-storage-queue.properties");
        CLIENT_NAME = properties.getOrDefault("name", "UnknownName");
        CLIENT_VERSION = properties.getOrDefault("version", "UnknownVersion");
    }

    public static class QueueUrlParts {
        private String scheme;
        private String endpoint;
        private String accountName;
        private String queueName;
        private String sasToken;

        public String getScheme() {
            return this.scheme;
        }

        public QueueUrlParts setScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public QueueUrlParts setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public QueueUrlParts setAccountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public String getQueueName() {
            return this.queueName;
        }

        QueueUrlParts setQueueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public String getSasToken() {
            return this.sasToken;
        }

        public QueueUrlParts setSasToken(String sasToken) {
            this.sasToken = sasToken;
            return this;
        }
    }
}

