// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Static definitions of the ProactiveDetection configuration rule (same values for all components). */
@Fluent
public final class ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions {
    /*
     * The rule name
     */
    @JsonProperty(value = "Name")
    private String name;

    /*
     * The rule name as it is displayed in UI
     */
    @JsonProperty(value = "DisplayName")
    private String displayName;

    /*
     * The rule description
     */
    @JsonProperty(value = "Description")
    private String description;

    /*
     * URL which displays additional info about the proactive detection rule
     */
    @JsonProperty(value = "HelpUrl")
    private String helpUrl;

    /*
     * A flag indicating whether the rule is hidden (from the UI)
     */
    @JsonProperty(value = "IsHidden")
    private Boolean isHidden;

    /*
     * A flag indicating whether the rule is enabled by default
     */
    @JsonProperty(value = "IsEnabledByDefault")
    private Boolean isEnabledByDefault;

    /*
     * A flag indicating whether the rule is in preview
     */
    @JsonProperty(value = "IsInPreview")
    private Boolean isInPreview;

    /*
     * A flag indicating whether email notifications are supported for
     * detections for this rule
     */
    @JsonProperty(value = "SupportsEmailNotifications")
    private Boolean supportsEmailNotifications;

    /**
     * Get the name property: The rule name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The rule name.
     *
     * @param name the name value to set.
     * @return the ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions object itself.
     */
    public ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: The rule name as it is displayed in UI.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The rule name as it is displayed in UI.
     *
     * @param displayName the displayName value to set.
     * @return the ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions object itself.
     */
    public ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions withDisplayName(
        String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The rule description.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The rule description.
     *
     * @param description the description value to set.
     * @return the ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions object itself.
     */
    public ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions withDescription(
        String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the helpUrl property: URL which displays additional info about the proactive detection rule.
     *
     * @return the helpUrl value.
     */
    public String helpUrl() {
        return this.helpUrl;
    }

    /**
     * Set the helpUrl property: URL which displays additional info about the proactive detection rule.
     *
     * @param helpUrl the helpUrl value to set.
     * @return the ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions object itself.
     */
    public ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions withHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
        return this;
    }

    /**
     * Get the isHidden property: A flag indicating whether the rule is hidden (from the UI).
     *
     * @return the isHidden value.
     */
    public Boolean isHidden() {
        return this.isHidden;
    }

    /**
     * Set the isHidden property: A flag indicating whether the rule is hidden (from the UI).
     *
     * @param isHidden the isHidden value to set.
     * @return the ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions object itself.
     */
    public ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions withIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    /**
     * Get the isEnabledByDefault property: A flag indicating whether the rule is enabled by default.
     *
     * @return the isEnabledByDefault value.
     */
    public Boolean isEnabledByDefault() {
        return this.isEnabledByDefault;
    }

    /**
     * Set the isEnabledByDefault property: A flag indicating whether the rule is enabled by default.
     *
     * @param isEnabledByDefault the isEnabledByDefault value to set.
     * @return the ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions object itself.
     */
    public ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions withIsEnabledByDefault(
        Boolean isEnabledByDefault) {
        this.isEnabledByDefault = isEnabledByDefault;
        return this;
    }

    /**
     * Get the isInPreview property: A flag indicating whether the rule is in preview.
     *
     * @return the isInPreview value.
     */
    public Boolean isInPreview() {
        return this.isInPreview;
    }

    /**
     * Set the isInPreview property: A flag indicating whether the rule is in preview.
     *
     * @param isInPreview the isInPreview value to set.
     * @return the ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions object itself.
     */
    public ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions withIsInPreview(
        Boolean isInPreview) {
        this.isInPreview = isInPreview;
        return this;
    }

    /**
     * Get the supportsEmailNotifications property: A flag indicating whether email notifications are supported for
     * detections for this rule.
     *
     * @return the supportsEmailNotifications value.
     */
    public Boolean supportsEmailNotifications() {
        return this.supportsEmailNotifications;
    }

    /**
     * Set the supportsEmailNotifications property: A flag indicating whether email notifications are supported for
     * detections for this rule.
     *
     * @param supportsEmailNotifications the supportsEmailNotifications value to set.
     * @return the ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions object itself.
     */
    public ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions withSupportsEmailNotifications(
        Boolean supportsEmailNotifications) {
        this.supportsEmailNotifications = supportsEmailNotifications;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
