/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.applicationinsights.fluent.AnalyticsItemsClient;
import com.azure.resourcemanager.applicationinsights.fluent.AnnotationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.ApiKeysClient;
import com.azure.resourcemanager.applicationinsights.fluent.ApplicationInsightsManagementClient;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentAvailableFeaturesClient;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentCurrentBillingFeaturesClient;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentFeatureCapabilitiesClient;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentLinkedStorageAccountsOperationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentQuotaStatusClient;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentsClient;
import com.azure.resourcemanager.applicationinsights.fluent.ExportConfigurationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.FavoritesClient;
import com.azure.resourcemanager.applicationinsights.fluent.LiveTokensClient;
import com.azure.resourcemanager.applicationinsights.fluent.MyWorkbooksClient;
import com.azure.resourcemanager.applicationinsights.fluent.OperationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.ProactiveDetectionConfigurationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.WebTestLocationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.WebTestsClient;
import com.azure.resourcemanager.applicationinsights.fluent.WorkItemConfigurationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.WorkbookTemplatesClient;
import com.azure.resourcemanager.applicationinsights.fluent.WorkbooksClient;
import com.azure.resourcemanager.applicationinsights.implementation.AnalyticsItemsClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.AnnotationsClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ApiKeysClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsManagementClientBuilder;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentAvailableFeaturesClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentCurrentBillingFeaturesClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentFeatureCapabilitiesClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentLinkedStorageAccountsOperationsClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentQuotaStatusClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentsClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ExportConfigurationsClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.FavoritesClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.LiveTokensClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.MyWorkbooksClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.OperationsClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.ProactiveDetectionConfigurationsClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.WebTestLocationsClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.WebTestsClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.WorkItemConfigurationsClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.WorkbookTemplatesClientImpl;
import com.azure.resourcemanager.applicationinsights.implementation.WorkbooksClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ApplicationInsightsManagementClientBuilder.class)
public final class ApplicationInsightsManagementClientImpl
implements ApplicationInsightsManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final AnnotationsClient annotations;
    private final ApiKeysClient apiKeys;
    private final ExportConfigurationsClient exportConfigurations;
    private final ComponentCurrentBillingFeaturesClient componentCurrentBillingFeatures;
    private final ComponentQuotaStatusClient componentQuotaStatus;
    private final ComponentFeatureCapabilitiesClient componentFeatureCapabilities;
    private final ComponentAvailableFeaturesClient componentAvailableFeatures;
    private final ProactiveDetectionConfigurationsClient proactiveDetectionConfigurations;
    private final WorkItemConfigurationsClient workItemConfigurations;
    private final FavoritesClient favorites;
    private final WebTestLocationsClient webTestLocations;
    private final WebTestsClient webTests;
    private final AnalyticsItemsClient analyticsItems;
    private final WorkbookTemplatesClient workbookTemplates;
    private final MyWorkbooksClient myWorkbooks;
    private final WorkbooksClient workbooks;
    private final ComponentsClient components;
    private final ComponentLinkedStorageAccountsOperationsClient componentLinkedStorageAccountsOperations;
    private final LiveTokensClient liveTokens;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationInsightsManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public AnnotationsClient getAnnotations() {
        return this.annotations;
    }

    @Override
    public ApiKeysClient getApiKeys() {
        return this.apiKeys;
    }

    @Override
    public ExportConfigurationsClient getExportConfigurations() {
        return this.exportConfigurations;
    }

    @Override
    public ComponentCurrentBillingFeaturesClient getComponentCurrentBillingFeatures() {
        return this.componentCurrentBillingFeatures;
    }

    @Override
    public ComponentQuotaStatusClient getComponentQuotaStatus() {
        return this.componentQuotaStatus;
    }

    @Override
    public ComponentFeatureCapabilitiesClient getComponentFeatureCapabilities() {
        return this.componentFeatureCapabilities;
    }

    @Override
    public ComponentAvailableFeaturesClient getComponentAvailableFeatures() {
        return this.componentAvailableFeatures;
    }

    @Override
    public ProactiveDetectionConfigurationsClient getProactiveDetectionConfigurations() {
        return this.proactiveDetectionConfigurations;
    }

    @Override
    public WorkItemConfigurationsClient getWorkItemConfigurations() {
        return this.workItemConfigurations;
    }

    @Override
    public FavoritesClient getFavorites() {
        return this.favorites;
    }

    @Override
    public WebTestLocationsClient getWebTestLocations() {
        return this.webTestLocations;
    }

    @Override
    public WebTestsClient getWebTests() {
        return this.webTests;
    }

    @Override
    public AnalyticsItemsClient getAnalyticsItems() {
        return this.analyticsItems;
    }

    @Override
    public WorkbookTemplatesClient getWorkbookTemplates() {
        return this.workbookTemplates;
    }

    @Override
    public MyWorkbooksClient getMyWorkbooks() {
        return this.myWorkbooks;
    }

    @Override
    public WorkbooksClient getWorkbooks() {
        return this.workbooks;
    }

    @Override
    public ComponentsClient getComponents() {
        return this.components;
    }

    @Override
    public ComponentLinkedStorageAccountsOperationsClient getComponentLinkedStorageAccountsOperations() {
        return this.componentLinkedStorageAccountsOperations;
    }

    @Override
    public LiveTokensClient getLiveTokens() {
        return this.liveTokens;
    }

    ApplicationInsightsManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.operations = new OperationsClientImpl(this);
        this.annotations = new AnnotationsClientImpl(this);
        this.apiKeys = new ApiKeysClientImpl(this);
        this.exportConfigurations = new ExportConfigurationsClientImpl(this);
        this.componentCurrentBillingFeatures = new ComponentCurrentBillingFeaturesClientImpl(this);
        this.componentQuotaStatus = new ComponentQuotaStatusClientImpl(this);
        this.componentFeatureCapabilities = new ComponentFeatureCapabilitiesClientImpl(this);
        this.componentAvailableFeatures = new ComponentAvailableFeaturesClientImpl(this);
        this.proactiveDetectionConfigurations = new ProactiveDetectionConfigurationsClientImpl(this);
        this.workItemConfigurations = new WorkItemConfigurationsClientImpl(this);
        this.favorites = new FavoritesClientImpl(this);
        this.webTestLocations = new WebTestLocationsClientImpl(this);
        this.webTests = new WebTestsClientImpl(this);
        this.analyticsItems = new AnalyticsItemsClientImpl(this);
        this.workbookTemplates = new WorkbookTemplatesClientImpl(this);
        this.myWorkbooks = new MyWorkbooksClientImpl(this);
        this.workbooks = new WorkbooksClientImpl(this);
        this.components = new ComponentsClientImpl(this);
        this.componentLinkedStorageAccountsOperations = new ComponentLinkedStorageAccountsOperationsClientImpl(this);
        this.liveTokens = new LiveTokensClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(s);
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

