// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Name availability result payload. */
@Fluent
public final class NameAvailability {
    /*
     * Indicates whether the name is available
     */
    @JsonProperty(value = "nameAvailable")
    private Boolean nameAvailable;

    /*
     * Reason why the name is not available
     */
    @JsonProperty(value = "reason")
    private String reason;

    /*
     * Message why the name is not available
     */
    @JsonProperty(value = "message")
    private String message;

    /**
     * Get the nameAvailable property: Indicates whether the name is available.
     *
     * @return the nameAvailable value.
     */
    public Boolean nameAvailable() {
        return this.nameAvailable;
    }

    /**
     * Set the nameAvailable property: Indicates whether the name is available.
     *
     * @param nameAvailable the nameAvailable value to set.
     * @return the NameAvailability object itself.
     */
    public NameAvailability withNameAvailable(Boolean nameAvailable) {
        this.nameAvailable = nameAvailable;
        return this;
    }

    /**
     * Get the reason property: Reason why the name is not available.
     *
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: Reason why the name is not available.
     *
     * @param reason the reason value to set.
     * @return the NameAvailability object itself.
     */
    public NameAvailability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Get the message property: Message why the name is not available.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Message why the name is not available.
     *
     * @param message the message value to set.
     * @return the NameAvailability object itself.
     */
    public NameAvailability withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
