// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Used for getting ResourceHealthCheck settings. */
@Fluent
public final class ResourceHealthMetadataInner extends ProxyOnlyResource {
    /*
     * ResourceHealthMetadata resource specific properties
     */
    @JsonProperty(value = "properties")
    private ResourceHealthMetadataProperties innerProperties;

    /**
     * Get the innerProperties property: ResourceHealthMetadata resource specific properties.
     *
     * @return the innerProperties value.
     */
    private ResourceHealthMetadataProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public ResourceHealthMetadataInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the category property: The category that the resource matches in the RHC Policy File.
     *
     * @return the category value.
     */
    public String category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    /**
     * Set the category property: The category that the resource matches in the RHC Policy File.
     *
     * @param category the category value to set.
     * @return the ResourceHealthMetadataInner object itself.
     */
    public ResourceHealthMetadataInner withCategory(String category) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResourceHealthMetadataProperties();
        }
        this.innerProperties().withCategory(category);
        return this;
    }

    /**
     * Get the signalAvailability property: Is there a health signal for the resource.
     *
     * @return the signalAvailability value.
     */
    public Boolean signalAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().signalAvailability();
    }

    /**
     * Set the signalAvailability property: Is there a health signal for the resource.
     *
     * @param signalAvailability the signalAvailability value to set.
     * @return the ResourceHealthMetadataInner object itself.
     */
    public ResourceHealthMetadataInner withSignalAvailability(Boolean signalAvailability) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResourceHealthMetadataProperties();
        }
        this.innerProperties().withSignalAvailability(signalAvailability);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
