// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** attendee. */
@Fluent
public final class MicrosoftGraphAttendee extends MicrosoftGraphAttendeeBase {
    /*
     * timeSlot
     */
    @JsonProperty(value = "proposedNewTime")
    private MicrosoftGraphTimeSlot proposedNewTime;

    /*
     * responseStatus
     */
    @JsonProperty(value = "status")
    private MicrosoftGraphResponseStatus status;

    /*
     * attendee
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphAttendee class. */
    public MicrosoftGraphAttendee() {
    }

    /**
     * Get the proposedNewTime property: timeSlot.
     *
     * @return the proposedNewTime value.
     */
    public MicrosoftGraphTimeSlot proposedNewTime() {
        return this.proposedNewTime;
    }

    /**
     * Set the proposedNewTime property: timeSlot.
     *
     * @param proposedNewTime the proposedNewTime value to set.
     * @return the MicrosoftGraphAttendee object itself.
     */
    public MicrosoftGraphAttendee withProposedNewTime(MicrosoftGraphTimeSlot proposedNewTime) {
        this.proposedNewTime = proposedNewTime;
        return this;
    }

    /**
     * Get the status property: responseStatus.
     *
     * @return the status value.
     */
    public MicrosoftGraphResponseStatus status() {
        return this.status;
    }

    /**
     * Set the status property: responseStatus.
     *
     * @param status the status value to set.
     * @return the MicrosoftGraphAttendee object itself.
     */
    public MicrosoftGraphAttendee withStatus(MicrosoftGraphResponseStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the additionalProperties property: attendee.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: attendee.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAttendee object itself.
     */
    public MicrosoftGraphAttendee withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphAttendee withType(MicrosoftGraphAttendeeType type) {
        super.withType(type);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphAttendee withEmailAddress(MicrosoftGraphEmailAddress emailAddress) {
        super.withEmailAddress(emailAddress);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (proposedNewTime() != null) {
            proposedNewTime().validate();
        }
        if (status() != null) {
            status().validate();
        }
    }
}
