// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** itemBody. */
@Fluent
public final class MicrosoftGraphItemBody {
    /*
     * The content of the item.
     */
    @JsonProperty(value = "content")
    private String content;

    /*
     * bodyType
     */
    @JsonProperty(value = "contentType")
    private MicrosoftGraphBodyType contentType;

    /*
     * itemBody
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphItemBody class. */
    public MicrosoftGraphItemBody() {
    }

    /**
     * Get the content property: The content of the item.
     *
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: The content of the item.
     *
     * @param content the content value to set.
     * @return the MicrosoftGraphItemBody object itself.
     */
    public MicrosoftGraphItemBody withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the contentType property: bodyType.
     *
     * @return the contentType value.
     */
    public MicrosoftGraphBodyType contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: bodyType.
     *
     * @param contentType the contentType value to set.
     * @return the MicrosoftGraphItemBody object itself.
     */
    public MicrosoftGraphItemBody withContentType(MicrosoftGraphBodyType contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the additionalProperties property: itemBody.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: itemBody.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphItemBody object itself.
     */
    public MicrosoftGraphItemBody withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
