// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * resourceSpecificPermissionGrant
 *
 * <p>Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
 * entity types.
 */
@Fluent
public final class MicrosoftGraphResourceSpecificPermissionGrant extends MicrosoftGraphDirectoryObjectInner {
    /*
     * The clientAppId property.
     */
    @JsonProperty(value = "clientAppId")
    private String clientAppId;

    /*
     * The clientId property.
     */
    @JsonProperty(value = "clientId")
    private String clientId;

    /*
     * The permission property.
     */
    @JsonProperty(value = "permission")
    private String permission;

    /*
     * The permissionType property.
     */
    @JsonProperty(value = "permissionType")
    private String permissionType;

    /*
     * The resourceAppId property.
     */
    @JsonProperty(value = "resourceAppId")
    private String resourceAppId;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
     * entity types.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphResourceSpecificPermissionGrant class. */
    public MicrosoftGraphResourceSpecificPermissionGrant() {
    }

    /**
     * Get the clientAppId property: The clientAppId property.
     *
     * @return the clientAppId value.
     */
    public String clientAppId() {
        return this.clientAppId;
    }

    /**
     * Set the clientAppId property: The clientAppId property.
     *
     * @param clientAppId the clientAppId value to set.
     * @return the MicrosoftGraphResourceSpecificPermissionGrant object itself.
     */
    public MicrosoftGraphResourceSpecificPermissionGrant withClientAppId(String clientAppId) {
        this.clientAppId = clientAppId;
        return this;
    }

    /**
     * Get the clientId property: The clientId property.
     *
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The clientId property.
     *
     * @param clientId the clientId value to set.
     * @return the MicrosoftGraphResourceSpecificPermissionGrant object itself.
     */
    public MicrosoftGraphResourceSpecificPermissionGrant withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the permission property: The permission property.
     *
     * @return the permission value.
     */
    public String permission() {
        return this.permission;
    }

    /**
     * Set the permission property: The permission property.
     *
     * @param permission the permission value to set.
     * @return the MicrosoftGraphResourceSpecificPermissionGrant object itself.
     */
    public MicrosoftGraphResourceSpecificPermissionGrant withPermission(String permission) {
        this.permission = permission;
        return this;
    }

    /**
     * Get the permissionType property: The permissionType property.
     *
     * @return the permissionType value.
     */
    public String permissionType() {
        return this.permissionType;
    }

    /**
     * Set the permissionType property: The permissionType property.
     *
     * @param permissionType the permissionType value to set.
     * @return the MicrosoftGraphResourceSpecificPermissionGrant object itself.
     */
    public MicrosoftGraphResourceSpecificPermissionGrant withPermissionType(String permissionType) {
        this.permissionType = permissionType;
        return this;
    }

    /**
     * Get the resourceAppId property: The resourceAppId property.
     *
     * @return the resourceAppId value.
     */
    public String resourceAppId() {
        return this.resourceAppId;
    }

    /**
     * Set the resourceAppId property: The resourceAppId property.
     *
     * @param resourceAppId the resourceAppId value to set.
     * @return the MicrosoftGraphResourceSpecificPermissionGrant object itself.
     */
    public MicrosoftGraphResourceSpecificPermissionGrant withResourceAppId(String resourceAppId) {
        this.resourceAppId = resourceAppId;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphResourceSpecificPermissionGrant object itself.
     */
    public MicrosoftGraphResourceSpecificPermissionGrant withAdditionalProperties(
        Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphResourceSpecificPermissionGrant withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphResourceSpecificPermissionGrant withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
