// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** visualInfo. */
@Fluent
public final class MicrosoftGraphVisualInfo {
    /*
     * imageInfo
     */
    @JsonProperty(value = "attribution")
    private MicrosoftGraphImageInfo attribution;

    /*
     * Optional. Background color used to render the activity in the UI - brand color for the application source of the
     * activity. Must be a valid hex color
     */
    @JsonProperty(value = "backgroundColor")
    private String backgroundColor;

    /*
     * Json
     */
    @JsonProperty(value = "content")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> content;

    /*
     * The description property.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Required. Short text description of the user's unique activity (for example, document name in cases where an
     * activity refers to document creation)
     */
    @JsonProperty(value = "displayText")
    private String displayText;

    /*
     * visualInfo
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphVisualInfo class. */
    public MicrosoftGraphVisualInfo() {
    }

    /**
     * Get the attribution property: imageInfo.
     *
     * @return the attribution value.
     */
    public MicrosoftGraphImageInfo attribution() {
        return this.attribution;
    }

    /**
     * Set the attribution property: imageInfo.
     *
     * @param attribution the attribution value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withAttribution(MicrosoftGraphImageInfo attribution) {
        this.attribution = attribution;
        return this;
    }

    /**
     * Get the backgroundColor property: Optional. Background color used to render the activity in the UI - brand color
     * for the application source of the activity. Must be a valid hex color.
     *
     * @return the backgroundColor value.
     */
    public String backgroundColor() {
        return this.backgroundColor;
    }

    /**
     * Set the backgroundColor property: Optional. Background color used to render the activity in the UI - brand color
     * for the application source of the activity. Must be a valid hex color.
     *
     * @param backgroundColor the backgroundColor value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    /**
     * Get the content property: Json.
     *
     * @return the content value.
     */
    public Map<String, Object> content() {
        return this.content;
    }

    /**
     * Set the content property: Json.
     *
     * @param content the content value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withContent(Map<String, Object> content) {
        this.content = content;
        return this;
    }

    /**
     * Get the description property: The description property.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     *
     * @param description the description value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayText property: Required. Short text description of the user's unique activity (for example,
     * document name in cases where an activity refers to document creation).
     *
     * @return the displayText value.
     */
    public String displayText() {
        return this.displayText;
    }

    /**
     * Set the displayText property: Required. Short text description of the user's unique activity (for example,
     * document name in cases where an activity refers to document creation).
     *
     * @param displayText the displayText value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withDisplayText(String displayText) {
        this.displayText = displayText;
        return this;
    }

    /**
     * Get the additionalProperties property: visualInfo.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: visualInfo.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphVisualInfo object itself.
     */
    public MicrosoftGraphVisualInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (attribution() != null) {
            attribution().validate();
        }
    }
}
