// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.cdn.models.ResourceUsageUnit;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Output of check resource usage API. */
@Immutable
public final class ResourceUsageInner {
    /*
     * Resource type for which the usage is provided.
     */
    @JsonProperty(value = "resourceType", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceType;

    /*
     * Unit of the usage. e.g. count.
     */
    @JsonProperty(value = "unit", access = JsonProperty.Access.WRITE_ONLY)
    private ResourceUsageUnit unit;

    /*
     * Actual value of usage on the specified resource type.
     */
    @JsonProperty(value = "currentValue", access = JsonProperty.Access.WRITE_ONLY)
    private Integer currentValue;

    /*
     * Quota of the specified resource type.
     */
    @JsonProperty(value = "limit", access = JsonProperty.Access.WRITE_ONLY)
    private Integer limit;

    /**
     * Get the resourceType property: Resource type for which the usage is provided.
     *
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Get the unit property: Unit of the usage. e.g. count.
     *
     * @return the unit value.
     */
    public ResourceUsageUnit unit() {
        return this.unit;
    }

    /**
     * Get the currentValue property: Actual value of usage on the specified resource type.
     *
     * @return the currentValue value.
     */
    public Integer currentValue() {
        return this.currentValue;
    }

    /**
     * Get the limit property: Quota of the specified resource type.
     *
     * @return the limit value.
     */
    public Integer limit() {
        return this.limit;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
