// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.RoleInstanceInner;
import com.azure.resourcemanager.compute.fluent.models.RoleInstanceViewInner;
import com.azure.resourcemanager.compute.models.InstanceViewTypes;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in CloudServiceRoleInstancesClient. */
public interface CloudServiceRoleInstancesClient {
    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * Gets a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role instance from a cloud service along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleInstanceInner>> getWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, InstanceViewTypes expand);

    /**
     * Gets a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role instance from a cloud service on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleInstanceInner> getAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Gets a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role instance from a cloud service along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleInstanceInner> getWithResponse(
        String roleInstanceName,
        String resourceGroupName,
        String cloudServiceName,
        InstanceViewTypes expand,
        Context context);

    /**
     * Gets a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role instance from a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleInstanceInner get(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Retrieves information about the run-time state of a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of the role instance along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleInstanceViewInner>> getInstanceViewWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Retrieves information about the run-time state of a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of the role instance on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleInstanceViewInner> getInstanceViewAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Retrieves information about the run-time state of a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of the role instance along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleInstanceViewInner> getInstanceViewWithResponse(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * Retrieves information about the run-time state of a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of the role instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleInstanceViewInner getInstanceView(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleInstanceInner> listAsync(String resourceGroupName, String cloudServiceName, InstanceViewTypes expand);

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RoleInstanceInner> listAsync(String resourceGroupName, String cloudServiceName);

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleInstanceInner> list(String resourceGroupName, String cloudServiceName);

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RoleInstanceInner> list(
        String resourceGroupName, String cloudServiceName, InstanceViewTypes expand, Context context);

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginRestartAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestart(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestart(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restartAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restart(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restart(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginReimageAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginReimage(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginReimage(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> reimageAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void reimage(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void reimage(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> rebuildWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginRebuildAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRebuild(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRebuild(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> rebuildAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void rebuild(String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void rebuild(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * Gets a remote desktop file for a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a remote desktop file for a role instance in a cloud service along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BinaryData>> getRemoteDesktopFileWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Gets a remote desktop file for a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a remote desktop file for a role instance in a cloud service on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BinaryData> getRemoteDesktopFileAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName);

    /**
     * Gets a remote desktop file for a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a remote desktop file for a role instance in a cloud service along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getRemoteDesktopFileWithResponse(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * Gets a remote desktop file for a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a remote desktop file for a role instance in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BinaryData getRemoteDesktopFile(String roleInstanceName, String resourceGroupName, String cloudServiceName);
}
