// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.compute.fluent.models.CommunityGalleryImageVersionInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in CommunityGalleryImageVersionsClient. */
public interface CommunityGalleryImageVersionsClient {
    /**
     * Get a community gallery image version.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @param galleryImageVersionName The name of the community gallery image version. Needs to follow semantic version
     *     name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit
     *     integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a community gallery image version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CommunityGalleryImageVersionInner>> getWithResponseAsync(
        String location, String publicGalleryName, String galleryImageName, String galleryImageVersionName);

    /**
     * Get a community gallery image version.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @param galleryImageVersionName The name of the community gallery image version. Needs to follow semantic version
     *     name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit
     *     integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a community gallery image version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CommunityGalleryImageVersionInner> getAsync(
        String location, String publicGalleryName, String galleryImageName, String galleryImageVersionName);

    /**
     * Get a community gallery image version.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @param galleryImageVersionName The name of the community gallery image version. Needs to follow semantic version
     *     name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit
     *     integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a community gallery image version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CommunityGalleryImageVersionInner> getWithResponse(
        String location,
        String publicGalleryName,
        String galleryImageName,
        String galleryImageVersionName,
        Context context);

    /**
     * Get a community gallery image version.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @param galleryImageVersionName The name of the community gallery image version. Needs to follow semantic version
     *     name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit
     *     integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a community gallery image version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CommunityGalleryImageVersionInner get(
        String location, String publicGalleryName, String galleryImageName, String galleryImageVersionName);

    /**
     * List community gallery image versions inside an image.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Community Gallery Image versions operation response as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CommunityGalleryImageVersionInner> listAsync(
        String location, String publicGalleryName, String galleryImageName);

    /**
     * List community gallery image versions inside an image.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Community Gallery Image versions operation response as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CommunityGalleryImageVersionInner> list(
        String location, String publicGalleryName, String galleryImageName);

    /**
     * List community gallery image versions inside an image.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Community Gallery Image versions operation response as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CommunityGalleryImageVersionInner> list(
        String location, String publicGalleryName, String galleryImageName, Context context);
}
