// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Specifies how the virtual machine should be created.&lt;br&gt;&lt;br&gt; Possible values are:&lt;br&gt;&lt;br&gt;
 * **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual
 * machine.&lt;br&gt;&lt;br&gt; **FromImage** \u2013 This value is used when you are using an image to create the
 * virtual machine. If you are using a platform image, you also use the imageReference element described above. If you
 * are using a marketplace image, you also use the plan element previously described.
 */
public final class DiskCreateOptionTypes extends ExpandableStringEnum<DiskCreateOptionTypes> {
    /** Static value FromImage for DiskCreateOptionTypes. */
    public static final DiskCreateOptionTypes FROM_IMAGE = fromString("FromImage");

    /** Static value Empty for DiskCreateOptionTypes. */
    public static final DiskCreateOptionTypes EMPTY = fromString("Empty");

    /** Static value Attach for DiskCreateOptionTypes. */
    public static final DiskCreateOptionTypes ATTACH = fromString("Attach");

    /**
     * Creates a new instance of DiskCreateOptionTypes value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DiskCreateOptionTypes() {
    }

    /**
     * Creates or finds a DiskCreateOptionTypes from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DiskCreateOptionTypes.
     */
    @JsonCreator
    public static DiskCreateOptionTypes fromString(String name) {
        return fromString(name, DiskCreateOptionTypes.class);
    }

    /**
     * Gets known DiskCreateOptionTypes values.
     *
     * @return known DiskCreateOptionTypes values.
     */
    public static Collection<DiskCreateOptionTypes> values() {
        return values(DiskCreateOptionTypes.class);
    }
}
