// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The instance view of a restore point. */
@Fluent
public final class RestorePointInstanceView {
    /*
     * The disk restore points information.
     */
    @JsonProperty(value = "diskRestorePoints")
    private List<DiskRestorePointInstanceView> diskRestorePoints;

    /*
     * The resource status information.
     */
    @JsonProperty(value = "statuses")
    private List<InstanceViewStatus> statuses;

    /** Creates an instance of RestorePointInstanceView class. */
    public RestorePointInstanceView() {
    }

    /**
     * Get the diskRestorePoints property: The disk restore points information.
     *
     * @return the diskRestorePoints value.
     */
    public List<DiskRestorePointInstanceView> diskRestorePoints() {
        return this.diskRestorePoints;
    }

    /**
     * Set the diskRestorePoints property: The disk restore points information.
     *
     * @param diskRestorePoints the diskRestorePoints value to set.
     * @return the RestorePointInstanceView object itself.
     */
    public RestorePointInstanceView withDiskRestorePoints(List<DiskRestorePointInstanceView> diskRestorePoints) {
        this.diskRestorePoints = diskRestorePoints;
        return this;
    }

    /**
     * Get the statuses property: The resource status information.
     *
     * @return the statuses value.
     */
    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    /**
     * Set the statuses property: The resource status information.
     *
     * @param statuses the statuses value to set.
     * @return the RestorePointInstanceView object itself.
     */
    public RestorePointInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskRestorePoints() != null) {
            diskRestorePoints().forEach(e -> e.validate());
        }
        if (statuses() != null) {
            statuses().forEach(e -> e.validate());
        }
    }
}
