// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** The properties of a scope map. */
@Fluent
public final class ScopeMapProperties {
    /*
     * The user friendly description of the scope map.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The type of the scope map. E.g. BuildIn scope map.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * The creation date of scope map.
     */
    @JsonProperty(value = "creationDate", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;

    /*
     * Provisioning state of the resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The list of scoped permissions for registry artifacts.
     * E.g. repositories/repository-name/content/read,
     * repositories/repository-name/metadata/write
     */
    @JsonProperty(value = "actions", required = true)
    private List<String> actions;

    /** Creates an instance of ScopeMapProperties class. */
    public ScopeMapProperties() {
    }

    /**
     * Get the description property: The user friendly description of the scope map.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The user friendly description of the scope map.
     *
     * @param description the description value to set.
     * @return the ScopeMapProperties object itself.
     */
    public ScopeMapProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the type property: The type of the scope map. E.g. BuildIn scope map.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the creationDate property: The creation date of scope map.
     *
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the actions property: The list of scoped permissions for registry artifacts. E.g.
     * repositories/repository-name/content/read, repositories/repository-name/metadata/write.
     *
     * @return the actions value.
     */
    public List<String> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: The list of scoped permissions for registry artifacts. E.g.
     * repositories/repository-name/content/read, repositories/repository-name/metadata/write.
     *
     * @param actions the actions value to set.
     * @return the ScopeMapProperties object itself.
     */
    public ScopeMapProperties withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (actions() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property actions in model ScopeMapProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ScopeMapProperties.class);
}
