// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.TokenCredentialsProperties;
import com.azure.resourcemanager.containerregistry.models.TokenStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** An object that represents a token for a container registry. */
@Fluent
public final class TokenInner extends ProxyResource {
    /*
     * The properties of the token.
     */
    @JsonProperty(value = "properties")
    private TokenProperties innerProperties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /** Creates an instance of TokenInner class. */
    public TokenInner() {
    }

    /**
     * Get the innerProperties property: The properties of the token.
     *
     * @return the innerProperties value.
     */
    private TokenProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the creationDate property: The creation date of scope map.
     *
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the scopeMapId property: The resource ID of the scope map to which the token will be associated with.
     *
     * @return the scopeMapId value.
     */
    public String scopeMapId() {
        return this.innerProperties() == null ? null : this.innerProperties().scopeMapId();
    }

    /**
     * Set the scopeMapId property: The resource ID of the scope map to which the token will be associated with.
     *
     * @param scopeMapId the scopeMapId value to set.
     * @return the TokenInner object itself.
     */
    public TokenInner withScopeMapId(String scopeMapId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TokenProperties();
        }
        this.innerProperties().withScopeMapId(scopeMapId);
        return this;
    }

    /**
     * Get the credentials property: The credentials that can be used for authenticating the token.
     *
     * @return the credentials value.
     */
    public TokenCredentialsProperties credentials() {
        return this.innerProperties() == null ? null : this.innerProperties().credentials();
    }

    /**
     * Set the credentials property: The credentials that can be used for authenticating the token.
     *
     * @param credentials the credentials value to set.
     * @return the TokenInner object itself.
     */
    public TokenInner withCredentials(TokenCredentialsProperties credentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TokenProperties();
        }
        this.innerProperties().withCredentials(credentials);
        return this;
    }

    /**
     * Get the status property: The status of the token example enabled or disabled.
     *
     * @return the status value.
     */
    public TokenStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: The status of the token example enabled or disabled.
     *
     * @param status the status value to set.
     * @return the TokenInner object itself.
     */
    public TokenInner withStatus(TokenStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TokenProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
