// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The type of the auto trigger for base image dependency updates. */
public final class BaseImageTriggerType extends ExpandableStringEnum<BaseImageTriggerType> {
    /** Static value All for BaseImageTriggerType. */
    public static final BaseImageTriggerType ALL = fromString("All");

    /** Static value Runtime for BaseImageTriggerType. */
    public static final BaseImageTriggerType RUNTIME = fromString("Runtime");

    /**
     * Creates a new instance of BaseImageTriggerType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public BaseImageTriggerType() {
    }

    /**
     * Creates or finds a BaseImageTriggerType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding BaseImageTriggerType.
     */
    @JsonCreator
    public static BaseImageTriggerType fromString(String name) {
        return fromString(name, BaseImageTriggerType.class);
    }

    /**
     * Gets known BaseImageTriggerType values.
     *
     * @return known BaseImageTriggerType values.
     */
    public static Collection<BaseImageTriggerType> values() {
        return values(BaseImageTriggerType.class);
    }
}
