// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/** The properties of a task step. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("FileTask")
@Fluent
public final class FileTaskStep extends TaskStepProperties {
    /*
     * The task template/definition file path relative to the source context.
     */
    @JsonProperty(value = "taskFilePath", required = true)
    private String taskFilePath;

    /*
     * The task values/parameters file path relative to the source context.
     */
    @JsonProperty(value = "valuesFilePath")
    private String valuesFilePath;

    /*
     * The collection of overridable values that can be passed when running a task.
     */
    @JsonProperty(value = "values")
    private List<SetValue> values;

    /** Creates an instance of FileTaskStep class. */
    public FileTaskStep() {
    }

    /**
     * Get the taskFilePath property: The task template/definition file path relative to the source context.
     *
     * @return the taskFilePath value.
     */
    public String taskFilePath() {
        return this.taskFilePath;
    }

    /**
     * Set the taskFilePath property: The task template/definition file path relative to the source context.
     *
     * @param taskFilePath the taskFilePath value to set.
     * @return the FileTaskStep object itself.
     */
    public FileTaskStep withTaskFilePath(String taskFilePath) {
        this.taskFilePath = taskFilePath;
        return this;
    }

    /**
     * Get the valuesFilePath property: The task values/parameters file path relative to the source context.
     *
     * @return the valuesFilePath value.
     */
    public String valuesFilePath() {
        return this.valuesFilePath;
    }

    /**
     * Set the valuesFilePath property: The task values/parameters file path relative to the source context.
     *
     * @param valuesFilePath the valuesFilePath value to set.
     * @return the FileTaskStep object itself.
     */
    public FileTaskStep withValuesFilePath(String valuesFilePath) {
        this.valuesFilePath = valuesFilePath;
        return this;
    }

    /**
     * Get the values property: The collection of overridable values that can be passed when running a task.
     *
     * @return the values value.
     */
    public List<SetValue> values() {
        return this.values;
    }

    /**
     * Set the values property: The collection of overridable values that can be passed when running a task.
     *
     * @param values the values value to set.
     * @return the FileTaskStep object itself.
     */
    public FileTaskStep withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public FileTaskStep withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public FileTaskStep withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (taskFilePath() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property taskFilePath in model FileTaskStep"));
        }
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FileTaskStep.class);
}
