// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The KeyVaultProperties model. */
@Fluent
public final class KeyVaultProperties {
    /*
     * Key vault uri to access the encryption key.
     */
    @JsonProperty(value = "keyIdentifier")
    private String keyIdentifier;

    /*
     * The fully qualified key identifier that includes the version of the key that is actually used for encryption.
     */
    @JsonProperty(value = "versionedKeyIdentifier", access = JsonProperty.Access.WRITE_ONLY)
    private String versionedKeyIdentifier;

    /*
     * The client id of the identity which will be used to access key vault.
     */
    @JsonProperty(value = "identity")
    private String identity;

    /*
     * Auto key rotation status for a CMK enabled registry.
     */
    @JsonProperty(value = "keyRotationEnabled", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean keyRotationEnabled;

    /*
     * Timestamp of the last successful key rotation.
     */
    @JsonProperty(value = "lastKeyRotationTimestamp", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastKeyRotationTimestamp;

    /** Creates an instance of KeyVaultProperties class. */
    public KeyVaultProperties() {
    }

    /**
     * Get the keyIdentifier property: Key vault uri to access the encryption key.
     *
     * @return the keyIdentifier value.
     */
    public String keyIdentifier() {
        return this.keyIdentifier;
    }

    /**
     * Set the keyIdentifier property: Key vault uri to access the encryption key.
     *
     * @param keyIdentifier the keyIdentifier value to set.
     * @return the KeyVaultProperties object itself.
     */
    public KeyVaultProperties withKeyIdentifier(String keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
        return this;
    }

    /**
     * Get the versionedKeyIdentifier property: The fully qualified key identifier that includes the version of the key
     * that is actually used for encryption.
     *
     * @return the versionedKeyIdentifier value.
     */
    public String versionedKeyIdentifier() {
        return this.versionedKeyIdentifier;
    }

    /**
     * Get the identity property: The client id of the identity which will be used to access key vault.
     *
     * @return the identity value.
     */
    public String identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The client id of the identity which will be used to access key vault.
     *
     * @param identity the identity value to set.
     * @return the KeyVaultProperties object itself.
     */
    public KeyVaultProperties withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the keyRotationEnabled property: Auto key rotation status for a CMK enabled registry.
     *
     * @return the keyRotationEnabled value.
     */
    public Boolean keyRotationEnabled() {
        return this.keyRotationEnabled;
    }

    /**
     * Get the lastKeyRotationTimestamp property: Timestamp of the last successful key rotation.
     *
     * @return the lastKeyRotationTimestamp value.
     */
    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
