// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryPropertiesUpdateParameters;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The parameters for updating a container registry. */
@Fluent
public final class RegistryUpdateParameters {
    /*
     * The identity of the container registry.
     */
    @JsonProperty(value = "identity")
    private IdentityProperties identity;

    /*
     * The tags for the container registry.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /*
     * The SKU of the container registry.
     */
    @JsonProperty(value = "sku")
    private Sku sku;

    /*
     * The properties that the container registry will be updated with.
     */
    @JsonProperty(value = "properties")
    private RegistryPropertiesUpdateParameters innerProperties;

    /** Creates an instance of RegistryUpdateParameters class. */
    public RegistryUpdateParameters() {
    }

    /**
     * Get the identity property: The identity of the container registry.
     *
     * @return the identity value.
     */
    public IdentityProperties identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity of the container registry.
     *
     * @param identity the identity value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the tags property: The tags for the container registry.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags for the container registry.
     *
     * @param tags the tags value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the sku property: The SKU of the container registry.
     *
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The SKU of the container registry.
     *
     * @param sku the sku value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the innerProperties property: The properties that the container registry will be updated with.
     *
     * @return the innerProperties value.
     */
    private RegistryPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the adminUserEnabled property: The value that indicates whether the admin user is enabled.
     *
     * @return the adminUserEnabled value.
     */
    public Boolean adminUserEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().adminUserEnabled();
    }

    /**
     * Set the adminUserEnabled property: The value that indicates whether the admin user is enabled.
     *
     * @param adminUserEnabled the adminUserEnabled value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withAdminUserEnabled(Boolean adminUserEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withAdminUserEnabled(adminUserEnabled);
        return this;
    }

    /**
     * Get the networkRuleSet property: The network rule set for a container registry.
     *
     * @return the networkRuleSet value.
     */
    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    /**
     * Set the networkRuleSet property: The network rule set for a container registry.
     *
     * @param networkRuleSet the networkRuleSet value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    /**
     * Get the policies property: The policies for a container registry.
     *
     * @return the policies value.
     */
    public Policies policies() {
        return this.innerProperties() == null ? null : this.innerProperties().policies();
    }

    /**
     * Set the policies property: The policies for a container registry.
     *
     * @param policies the policies value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withPolicies(Policies policies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withPolicies(policies);
        return this;
    }

    /**
     * Get the encryption property: The encryption settings of container registry.
     *
     * @return the encryption value.
     */
    public EncryptionProperty encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    /**
     * Set the encryption property: The encryption settings of container registry.
     *
     * @param encryption the encryption value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withEncryption(EncryptionProperty encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    /**
     * Get the dataEndpointEnabled property: Enable a single data endpoint per region for serving data.
     *
     * @return the dataEndpointEnabled value.
     */
    public Boolean dataEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEndpointEnabled();
    }

    /**
     * Set the dataEndpointEnabled property: Enable a single data endpoint per region for serving data.
     *
     * @param dataEndpointEnabled the dataEndpointEnabled value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withDataEndpointEnabled(dataEndpointEnabled);
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public network access is allowed for the container registry.
     *
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public network access is allowed for the container registry.
     *
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    /**
     * Get the networkRuleBypassOptions property: Whether to allow trusted Azure services to access a network restricted
     * registry.
     *
     * @return the networkRuleBypassOptions value.
     */
    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleBypassOptions();
    }

    /**
     * Set the networkRuleBypassOptions property: Whether to allow trusted Azure services to access a network restricted
     * registry.
     *
     * @param networkRuleBypassOptions the networkRuleBypassOptions value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withNetworkRuleBypassOptions(networkRuleBypassOptions);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
