// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskPropertiesUpdateParameters;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The parameters for updating a task. */
@Fluent
public final class TaskUpdateParameters {
    /*
     * Identity for the resource.
     */
    @JsonProperty(value = "identity")
    private IdentityProperties identity;

    /*
     * The properties for updating a task.
     */
    @JsonProperty(value = "properties")
    private TaskPropertiesUpdateParameters innerProperties;

    /*
     * The ARM resource tags.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /** Creates an instance of TaskUpdateParameters class. */
    public TaskUpdateParameters() {
    }

    /**
     * Get the identity property: Identity for the resource.
     *
     * @return the identity value.
     */
    public IdentityProperties identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Identity for the resource.
     *
     * @param identity the identity value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: The properties for updating a task.
     *
     * @return the innerProperties value.
     */
    private TaskPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the tags property: The ARM resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The ARM resource tags.
     *
     * @param tags the tags value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the status property: The current status of task.
     *
     * @return the status value.
     */
    public TaskStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: The current status of task.
     *
     * @param status the status value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withStatus(TaskStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the platform property: The platform properties against which the run has to happen.
     *
     * @return the platform value.
     */
    public PlatformUpdateParameters platform() {
        return this.innerProperties() == null ? null : this.innerProperties().platform();
    }

    /**
     * Set the platform property: The platform properties against which the run has to happen.
     *
     * @param platform the platform value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withPlatform(PlatformUpdateParameters platform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withPlatform(platform);
        return this;
    }

    /**
     * Get the agentConfiguration property: The machine configuration of the run agent.
     *
     * @return the agentConfiguration value.
     */
    public AgentProperties agentConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().agentConfiguration();
    }

    /**
     * Set the agentConfiguration property: The machine configuration of the run agent.
     *
     * @param agentConfiguration the agentConfiguration value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withAgentConfiguration(AgentProperties agentConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withAgentConfiguration(agentConfiguration);
        return this;
    }

    /**
     * Get the agentPoolName property: The dedicated agent pool for the task.
     *
     * @return the agentPoolName value.
     */
    public String agentPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().agentPoolName();
    }

    /**
     * Set the agentPoolName property: The dedicated agent pool for the task.
     *
     * @param agentPoolName the agentPoolName value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withAgentPoolName(String agentPoolName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withAgentPoolName(agentPoolName);
        return this;
    }

    /**
     * Get the timeout property: Run timeout in seconds.
     *
     * @return the timeout value.
     */
    public Integer timeout() {
        return this.innerProperties() == null ? null : this.innerProperties().timeout();
    }

    /**
     * Set the timeout property: Run timeout in seconds.
     *
     * @param timeout the timeout value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withTimeout(Integer timeout) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withTimeout(timeout);
        return this;
    }

    /**
     * Get the step property: The properties for updating a task step.
     *
     * @return the step value.
     */
    public TaskStepUpdateParameters step() {
        return this.innerProperties() == null ? null : this.innerProperties().step();
    }

    /**
     * Set the step property: The properties for updating a task step.
     *
     * @param step the step value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withStep(TaskStepUpdateParameters step) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withStep(step);
        return this;
    }

    /**
     * Get the trigger property: The properties for updating trigger properties.
     *
     * @return the trigger value.
     */
    public TriggerUpdateParameters trigger() {
        return this.innerProperties() == null ? null : this.innerProperties().trigger();
    }

    /**
     * Set the trigger property: The properties for updating trigger properties.
     *
     * @param trigger the trigger value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withTrigger(TriggerUpdateParameters trigger) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withTrigger(trigger);
        return this;
    }

    /**
     * Get the credentials property: The parameters that describes a set of credentials that will be used when this run
     * is invoked.
     *
     * @return the credentials value.
     */
    public Credentials credentials() {
        return this.innerProperties() == null ? null : this.innerProperties().credentials();
    }

    /**
     * Set the credentials property: The parameters that describes a set of credentials that will be used when this run
     * is invoked.
     *
     * @param credentials the credentials value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withCredentials(Credentials credentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withCredentials(credentials);
        return this;
    }

    /**
     * Get the logTemplate property: The template that describes the repository and tag information for run log
     * artifact.
     *
     * @return the logTemplate value.
     */
    public String logTemplate() {
        return this.innerProperties() == null ? null : this.innerProperties().logTemplate();
    }

    /**
     * Set the logTemplate property: The template that describes the repository and tag information for run log
     * artifact.
     *
     * @param logTemplate the logTemplate value to set.
     * @return the TaskUpdateParameters object itself.
     */
    public TaskUpdateParameters withLogTemplate(String logTemplate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withLogTemplate(logTemplate);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
