/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerregistry.fluent.ScopeMapsClient;
import com.azure.resourcemanager.containerregistry.fluent.models.ScopeMapInner;
import com.azure.resourcemanager.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.azure.resourcemanager.containerregistry.models.ScopeMapListResult;
import com.azure.resourcemanager.containerregistry.models.ScopeMapUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ScopeMapsClientImpl
implements ScopeMapsClient {
    private final ScopeMapsService service;
    private final ContainerRegistryManagementClientImpl client;

    ScopeMapsClientImpl(ContainerRegistryManagementClientImpl client) {
        this.service = (ScopeMapsService)RestProxy.create(ScopeMapsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ScopeMapInner>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2022-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2022-12-01", this.client.getSubscriptionId(), resourceGroupName, registryName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ScopeMapListResult)res.getValue()).value(), ((ScopeMapListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ScopeMapInner>> listSinglePageAsync(String resourceGroupName, String registryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2022-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2022-12-01", this.client.getSubscriptionId(), resourceGroupName, registryName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ScopeMapListResult)res.getValue()).value(), ((ScopeMapListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ScopeMapInner> listAsync(String resourceGroupName, String registryName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ScopeMapInner> listAsync(String resourceGroupName, String registryName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ScopeMapInner> list(String resourceGroupName, String registryName) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ScopeMapInner> list(String resourceGroupName, String registryName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ScopeMapInner>> getWithResponseAsync(String resourceGroupName, String registryName, String scopeMapName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (scopeMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapName is required and cannot be null."));
        }
        String apiVersion = "2022-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2022-12-01", this.client.getSubscriptionId(), resourceGroupName, registryName, scopeMapName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScopeMapInner>> getWithResponseAsync(String resourceGroupName, String registryName, String scopeMapName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (scopeMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapName is required and cannot be null."));
        }
        String apiVersion = "2022-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2022-12-01", this.client.getSubscriptionId(), resourceGroupName, registryName, scopeMapName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ScopeMapInner> getAsync(String resourceGroupName, String registryName, String scopeMapName) {
        return this.getWithResponseAsync(resourceGroupName, registryName, scopeMapName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ScopeMapInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ScopeMapInner> getWithResponse(String resourceGroupName, String registryName, String scopeMapName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, registryName, scopeMapName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScopeMapInner get(String resourceGroupName, String registryName, String scopeMapName) {
        return (ScopeMapInner)((Object)this.getWithResponse(resourceGroupName, registryName, scopeMapName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapInner scopeMapCreateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (scopeMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapName is required and cannot be null."));
        }
        if (scopeMapCreateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapCreateParameters is required and cannot be null."));
        }
        scopeMapCreateParameters.validate();
        String apiVersion = "2022-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2022-12-01", this.client.getSubscriptionId(), resourceGroupName, registryName, scopeMapName, scopeMapCreateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapInner scopeMapCreateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (scopeMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapName is required and cannot be null."));
        }
        if (scopeMapCreateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapCreateParameters is required and cannot be null."));
        }
        scopeMapCreateParameters.validate();
        String apiVersion = "2022-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), "2022-12-01", this.client.getSubscriptionId(), resourceGroupName, registryName, scopeMapName, scopeMapCreateParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ScopeMapInner>, ScopeMapInner> beginCreateAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapInner scopeMapCreateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, scopeMapName, scopeMapCreateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ScopeMapInner.class), (Type)((Object)ScopeMapInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ScopeMapInner>, ScopeMapInner> beginCreateAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapInner scopeMapCreateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, scopeMapName, scopeMapCreateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ScopeMapInner.class), (Type)((Object)ScopeMapInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ScopeMapInner>, ScopeMapInner> beginCreate(String resourceGroupName, String registryName, String scopeMapName, ScopeMapInner scopeMapCreateParameters) {
        return this.beginCreateAsync(resourceGroupName, registryName, scopeMapName, scopeMapCreateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ScopeMapInner>, ScopeMapInner> beginCreate(String resourceGroupName, String registryName, String scopeMapName, ScopeMapInner scopeMapCreateParameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, scopeMapName, scopeMapCreateParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ScopeMapInner> createAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapInner scopeMapCreateParameters) {
        return this.beginCreateAsync(resourceGroupName, registryName, scopeMapName, scopeMapCreateParameters).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScopeMapInner> createAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapInner scopeMapCreateParameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, scopeMapName, scopeMapCreateParameters, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScopeMapInner create(String resourceGroupName, String registryName, String scopeMapName, ScopeMapInner scopeMapCreateParameters) {
        return (ScopeMapInner)((Object)this.createAsync(resourceGroupName, registryName, scopeMapName, scopeMapCreateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScopeMapInner create(String resourceGroupName, String registryName, String scopeMapName, ScopeMapInner scopeMapCreateParameters, Context context) {
        return (ScopeMapInner)((Object)this.createAsync(resourceGroupName, registryName, scopeMapName, scopeMapCreateParameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String scopeMapName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (scopeMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapName is required and cannot be null."));
        }
        String apiVersion = "2022-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2022-12-01", this.client.getSubscriptionId(), resourceGroupName, registryName, scopeMapName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String scopeMapName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (scopeMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapName is required and cannot be null."));
        }
        String apiVersion = "2022-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2022-12-01", this.client.getSubscriptionId(), resourceGroupName, registryName, scopeMapName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String scopeMapName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, scopeMapName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String scopeMapName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, scopeMapName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String scopeMapName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, scopeMapName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String scopeMapName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, scopeMapName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String registryName, String scopeMapName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, scopeMapName).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String registryName, String scopeMapName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, scopeMapName, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String scopeMapName) {
        this.deleteAsync(resourceGroupName, registryName, scopeMapName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String scopeMapName, Context context) {
        this.deleteAsync(resourceGroupName, registryName, scopeMapName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapUpdateParameters scopeMapUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (scopeMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapName is required and cannot be null."));
        }
        if (scopeMapUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapUpdateParameters is required and cannot be null."));
        }
        scopeMapUpdateParameters.validate();
        String apiVersion = "2022-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2022-12-01", this.client.getSubscriptionId(), resourceGroupName, registryName, scopeMapName, scopeMapUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapUpdateParameters scopeMapUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (scopeMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapName is required and cannot be null."));
        }
        if (scopeMapUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeMapUpdateParameters is required and cannot be null."));
        }
        scopeMapUpdateParameters.validate();
        String apiVersion = "2022-12-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2022-12-01", this.client.getSubscriptionId(), resourceGroupName, registryName, scopeMapName, scopeMapUpdateParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ScopeMapInner>, ScopeMapInner> beginUpdateAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapUpdateParameters scopeMapUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, scopeMapName, scopeMapUpdateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ScopeMapInner.class), (Type)((Object)ScopeMapInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ScopeMapInner>, ScopeMapInner> beginUpdateAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapUpdateParameters scopeMapUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, scopeMapName, scopeMapUpdateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ScopeMapInner.class), (Type)((Object)ScopeMapInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ScopeMapInner>, ScopeMapInner> beginUpdate(String resourceGroupName, String registryName, String scopeMapName, ScopeMapUpdateParameters scopeMapUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, registryName, scopeMapName, scopeMapUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ScopeMapInner>, ScopeMapInner> beginUpdate(String resourceGroupName, String registryName, String scopeMapName, ScopeMapUpdateParameters scopeMapUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, scopeMapName, scopeMapUpdateParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ScopeMapInner> updateAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapUpdateParameters scopeMapUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, registryName, scopeMapName, scopeMapUpdateParameters).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScopeMapInner> updateAsync(String resourceGroupName, String registryName, String scopeMapName, ScopeMapUpdateParameters scopeMapUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, scopeMapName, scopeMapUpdateParameters, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScopeMapInner update(String resourceGroupName, String registryName, String scopeMapName, ScopeMapUpdateParameters scopeMapUpdateParameters) {
        return (ScopeMapInner)((Object)this.updateAsync(resourceGroupName, registryName, scopeMapName, scopeMapUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScopeMapInner update(String resourceGroupName, String registryName, String scopeMapName, ScopeMapUpdateParameters scopeMapUpdateParameters, Context context) {
        return (ScopeMapInner)((Object)this.updateAsync(resourceGroupName, registryName, scopeMapName, scopeMapUpdateParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ScopeMapInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ScopeMapListResult)res.getValue()).value(), ((ScopeMapListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ScopeMapInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ScopeMapListResult)res.getValue()).value(), ((ScopeMapListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerRegistryMan")
    public static interface ScopeMapsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/scopeMaps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScopeMapListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/scopeMaps/{scopeMapName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScopeMapInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="scopeMapName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/scopeMaps/{scopeMapName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="scopeMapName") String var6, @BodyParam(value="application/json") ScopeMapInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/scopeMaps/{scopeMapName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="scopeMapName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/scopeMaps/{scopeMapName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="scopeMapName") String var6, @BodyParam(value="application/json") ScopeMapUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScopeMapListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

