// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ManagedClusterPodIdentityProvisioningInfo model. */
@Fluent
public final class ManagedClusterPodIdentityProvisioningInfo {
    /*
     * Pod identity assignment error (if any).
     */
    @JsonProperty(value = "error")
    private ManagedClusterPodIdentityProvisioningError error;

    /** Creates an instance of ManagedClusterPodIdentityProvisioningInfo class. */
    public ManagedClusterPodIdentityProvisioningInfo() {
    }

    /**
     * Get the error property: Pod identity assignment error (if any).
     *
     * @return the error value.
     */
    public ManagedClusterPodIdentityProvisioningError error() {
        return this.error;
    }

    /**
     * Set the error property: Pod identity assignment error (if any).
     *
     * @param error the error value to set.
     * @return the ManagedClusterPodIdentityProvisioningInfo object itself.
     */
    public ManagedClusterPodIdentityProvisioningInfo withError(ManagedClusterPodIdentityProvisioningError error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (error() != null) {
            error().validate();
        }
    }
}
