// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The object that represents all properties related to capacity enforcement on an account. */
@Fluent
public final class Capacity {
    /*
     * The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max
     * throughput that can be provisioned on that account to be 2000. A totalThroughputLimit of -1 indicates no limits
     * on provisioning of throughput.
     */
    @JsonProperty(value = "totalThroughputLimit")
    private Integer totalThroughputLimit;

    /** Creates an instance of Capacity class. */
    public Capacity() {
    }

    /**
     * Get the totalThroughputLimit property: The total throughput limit imposed on the account. A totalThroughputLimit
     * of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A
     * totalThroughputLimit of -1 indicates no limits on provisioning of throughput.
     *
     * @return the totalThroughputLimit value.
     */
    public Integer totalThroughputLimit() {
        return this.totalThroughputLimit;
    }

    /**
     * Set the totalThroughputLimit property: The total throughput limit imposed on the account. A totalThroughputLimit
     * of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A
     * totalThroughputLimit of -1 indicates no limits on provisioning of throughput.
     *
     * @param totalThroughputLimit the totalThroughputLimit value to set.
     * @return the Capacity object itself.
     */
    public Capacity withTotalThroughputLimit(Integer totalThroughputLimit) {
        this.totalThroughputLimit = totalThroughputLimit;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
