// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Specific Gremlin Databases to restore. */
@Fluent
public final class GremlinDatabaseRestoreResource {
    /*
     * The name of the gremlin database available for restore.
     */
    @JsonProperty(value = "databaseName")
    private String databaseName;

    /*
     * The names of the graphs available for restore.
     */
    @JsonProperty(value = "graphNames")
    private List<String> graphNames;

    /** Creates an instance of GremlinDatabaseRestoreResource class. */
    public GremlinDatabaseRestoreResource() {
    }

    /**
     * Get the databaseName property: The name of the gremlin database available for restore.
     *
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Set the databaseName property: The name of the gremlin database available for restore.
     *
     * @param databaseName the databaseName value to set.
     * @return the GremlinDatabaseRestoreResource object itself.
     */
    public GremlinDatabaseRestoreResource withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    /**
     * Get the graphNames property: The names of the graphs available for restore.
     *
     * @return the graphNames value.
     */
    public List<String> graphNames() {
        return this.graphNames;
    }

    /**
     * Set the graphNames property: The names of the graphs available for restore.
     *
     * @param graphNames the graphNames value to set.
     * @return the GremlinDatabaseRestoreResource object itself.
     */
    public GremlinDatabaseRestoreResource withGraphNames(List<String> graphNames) {
        this.graphNames = graphNames;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
