// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Indicates the indexing mode. */
public final class IndexingMode extends ExpandableStringEnum<IndexingMode> {
    /** Static value consistent for IndexingMode. */
    public static final IndexingMode CONSISTENT = fromString("consistent");

    /** Static value lazy for IndexingMode. */
    public static final IndexingMode LAZY = fromString("lazy");

    /** Static value none for IndexingMode. */
    public static final IndexingMode NONE = fromString("none");

    /**
     * Creates a new instance of IndexingMode value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IndexingMode() {
    }

    /**
     * Creates or finds a IndexingMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding IndexingMode.
     */
    @JsonCreator
    public static IndexingMode fromString(String name) {
        return fromString(name, IndexingMode.class);
    }

    /**
     * Gets known IndexingMode values.
     *
     * @return known IndexingMode values.
     */
    public static Collection<IndexingMode> values() {
        return values(IndexingMode.class);
    }
}
