// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableMongodbResourcesGetResultInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The List operation response, that contains the restorable MongoDB resources. */
@Immutable
public final class RestorableMongodbResourcesListResult {
    /*
     * List of restorable MongoDB resources, including the database and collection names.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<RestorableMongodbResourcesGetResultInner> value;

    /** Creates an instance of RestorableMongodbResourcesListResult class. */
    public RestorableMongodbResourcesListResult() {
    }

    /**
     * Get the value property: List of restorable MongoDB resources, including the database and collection names.
     *
     * @return the value value.
     */
    public List<RestorableMongodbResourcesGetResultInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
