/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.management.Region;
import com.azure.resourcemanager.cosmos.CosmosManager;
import com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountGetResultsInner;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKind;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountListConnectionStringsResult;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountListKeysResult;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountListReadOnlyKeysResult;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountOfferType;
import com.azure.resourcemanager.cosmos.models.DefaultConsistencyLevel;
import com.azure.resourcemanager.cosmos.models.IpAddressOrRange;
import com.azure.resourcemanager.cosmos.models.KeyKind;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.PrivateEndpointConnection;
import com.azure.resourcemanager.cosmos.models.PrivateLinkResource;
import com.azure.resourcemanager.cosmos.models.SqlDatabase;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsUpdatingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public interface CosmosDBAccount
extends GroupableResource<CosmosManager, DatabaseAccountGetResultsInner>,
Refreshable<CosmosDBAccount>,
Updatable<Update>,
SupportsUpdatingPrivateEndpointConnection {
    public DatabaseAccountKind kind();

    public String documentEndpoint();

    public DatabaseAccountOfferType databaseAccountOfferType();

    @Deprecated
    public String ipRangeFilter();

    public List<IpAddressOrRange> ipRules();

    public ConsistencyPolicy consistencyPolicy();

    public DefaultConsistencyLevel defaultConsistencyLevel();

    public List<Location> writableReplications();

    public List<Location> readableReplications();

    public DatabaseAccountListKeysResult listKeys();

    public Mono<DatabaseAccountListKeysResult> listKeysAsync();

    public DatabaseAccountListReadOnlyKeysResult listReadOnlyKeys();

    public Mono<DatabaseAccountListReadOnlyKeysResult> listReadOnlyKeysAsync();

    public DatabaseAccountListConnectionStringsResult listConnectionStrings();

    public Mono<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync();

    public List<SqlDatabase> listSqlDatabases();

    public PagedFlux<SqlDatabase> listSqlDatabasesAsync();

    public boolean multipleWriteLocationsEnabled();

    public boolean cassandraConnectorEnabled();

    public ConnectorOffer cassandraConnectorOffer();

    public boolean keyBasedMetadataWriteAccessDisabled();

    public PagedFlux<PrivateLinkResource> listPrivateLinkResourcesAsync();

    public List<PrivateLinkResource> listPrivateLinkResources();

    public Mono<PrivateLinkResource> getPrivateLinkResourceAsync(String var1);

    public PrivateLinkResource getPrivateLinkResource(String var1);

    public Mono<Map<String, PrivateEndpointConnection>> listPrivateEndpointConnectionAsync();

    public Map<String, PrivateEndpointConnection> listPrivateEndpointConnection();

    public Mono<PrivateEndpointConnection> getPrivateEndpointConnectionAsync(String var1);

    public PrivateEndpointConnection getPrivateEndpointConnection(String var1);

    public List<Capability> capabilities();

    public List<VirtualNetworkRule> virtualNetworkRules();

    public void offlineRegion(Region var1);

    public Mono<Void> offlineRegionAsync(Region var1);

    public void onlineRegion(Region var1);

    public Mono<Void> onlineRegionAsync(Region var1);

    public void regenerateKey(KeyKind var1);

    public Mono<Void> regenerateKeyAsync(KeyKind var1);

    public static interface UpdateStages {

        public static interface WithPrivateEndpointConnection {
            public PrivateEndpointConnection.UpdateDefinitionStages.Blank<WithOptionals> defineNewPrivateEndpointConnection(String var1);

            public PrivateEndpointConnection.Update updatePrivateEndpointConnection(String var1);

            public WithOptionals withoutPrivateEndpointConnection(String var1);
        }

        public static interface WithKeyBasedMetadataWriteAccess {
            public WithOptionals withDisableKeyBaseMetadataWriteAccess(boolean var1);
        }

        public static interface WithConnector {
            public WithOptionals withCassandraConnector(ConnectorOffer var1);

            public WithOptionals withoutCassandraConnector();
        }

        public static interface WithMultipleLocations {
            public WithOptionals withMultipleWriteLocationsEnabled(boolean var1);
        }

        public static interface WithVirtualNetworkRule {
            public WithOptionals withVirtualNetwork(String var1, String var2);

            public WithOptionals withoutVirtualNetwork(String var1, String var2);

            public WithOptionals withVirtualNetworkRules(List<VirtualNetworkRule> var1);
        }

        public static interface WithIpRules {
            @Deprecated
            public WithOptionals withIpRangeFilter(String var1);

            public WithOptionals withIpRules(List<IpAddressOrRange> var1);
        }

        public static interface WithConsistencyPolicy {
            public WithOptionals withEventualConsistency();

            public WithOptionals withSessionConsistency();

            public WithOptionals withBoundedStalenessConsistency(long var1, int var3);

            public WithOptionals withStrongConsistency();
        }

        public static interface WithReadLocations
        extends Appliable<CosmosDBAccount> {
            public WithReadLocations withReadReplication(Region var1);

            public WithReadLocations withoutReadReplication(Region var1);
        }

        public static interface WithOptionals
        extends Resource.UpdateWithTags<WithOptionals>,
        Appliable<CosmosDBAccount>,
        WithConsistencyPolicy,
        WithVirtualNetworkRule,
        WithMultipleLocations,
        WithConnector,
        WithKeyBasedMetadataWriteAccess,
        WithPrivateEndpointConnection,
        WithIpRules {
        }
    }

    public static interface Update
    extends UpdateStages.WithReadLocations,
    UpdateStages.WithOptionals {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<CosmosDBAccount>,
        WithConsistencyPolicy,
        WithReadReplication,
        WithIpRules,
        WithVirtualNetworkRule,
        WithMultipleLocations,
        WithConnector,
        WithKeyBasedMetadataWriteAccess,
        WithPrivateEndpointConnection,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithPrivateEndpointConnection {
            public PrivateEndpointConnection.DefinitionStages.Blank<WithCreate> defineNewPrivateEndpointConnection(String var1);
        }

        public static interface WithKeyBasedMetadataWriteAccess {
            public WithCreate withDisableKeyBaseMetadataWriteAccess(boolean var1);
        }

        public static interface WithConnector {
            public WithCreate withCassandraConnector(ConnectorOffer var1);
        }

        public static interface WithMultipleLocations {
            public WithCreate withMultipleWriteLocationsEnabled(boolean var1);
        }

        public static interface WithVirtualNetworkRule {
            public WithCreate withVirtualNetwork(String var1, String var2);

            public WithCreate withVirtualNetworkRules(List<VirtualNetworkRule> var1);
        }

        public static interface WithReadReplication {
            public WithCreate withReadReplication(Region var1);
        }

        public static interface WithWriteReplication {
            public WithCreate withWriteReplication(Region var1);
        }

        public static interface WithIpRules {
            @Deprecated
            public WithCreate withIpRangeFilter(String var1);

            public WithCreate withIpRules(List<IpAddressOrRange> var1);
        }

        public static interface WithConsistencyPolicy {
            public WithWriteReplication withEventualConsistency();

            public WithWriteReplication withSessionConsistency();

            public WithWriteReplication withBoundedStalenessConsistency(long var1, int var3);

            public WithCreate withStrongConsistency();
        }

        public static interface WithKind {
            public WithConsistencyPolicy withKind(DatabaseAccountKind var1);

            public WithConsistencyPolicy withKind(DatabaseAccountKind var1, Capability ... var2);

            public WithConsistencyPolicy withDataModelSql();

            public WithConsistencyPolicy withDataModelMongoDB();

            public WithConsistencyPolicy withDataModelCassandra();

            public WithConsistencyPolicy withDataModelAzureTable();

            public WithConsistencyPolicy withDataModelGremlin();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithKind> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithKind,
    DefinitionStages.WithWriteReplication,
    DefinitionStages.WithReadReplication,
    DefinitionStages.WithCreate {
    }
}

