/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dns.DnsZoneManager;
import com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.dns.implementation.DnsRecordSetsBaseImpl;
import com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.azure.resourcemanager.dns.implementation.MxRecordSetImpl;
import com.azure.resourcemanager.dns.models.MxRecordSet;
import com.azure.resourcemanager.dns.models.MxRecordSets;
import com.azure.resourcemanager.dns.models.RecordType;
import reactor.core.publisher.Mono;

class MxRecordSetsImpl
extends DnsRecordSetsBaseImpl<MxRecordSet, MxRecordSetImpl>
implements MxRecordSets {
    MxRecordSetsImpl(DnsZoneImpl dnsZone) {
        super(dnsZone, RecordType.MX);
    }

    public MxRecordSet getByName(String name) {
        return (MxRecordSet)this.getByNameAsync(name).block();
    }

    public Mono<MxRecordSet> getByNameAsync(String name) {
        return ((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().getAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), name, this.recordType).map(this::wrapModel);
    }

    @Override
    public PagedIterable<MxRecordSet> list() {
        return super.wrapList(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByType(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType));
    }

    @Override
    protected PagedIterable<MxRecordSet> listIntern(String recordSetNameSuffix, Integer pageSize) {
        return super.wrapList(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByType(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType, pageSize, recordSetNameSuffix, Context.NONE));
    }

    @Override
    protected PagedFlux<MxRecordSet> listInternAsync(String recordSetNameSuffix, Integer pageSize) {
        return this.wrapPageAsync(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByTypeAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType));
    }

    protected MxRecordSetImpl wrapModel(RecordSetInner inner) {
        if (inner == null) {
            return null;
        }
        return new MxRecordSetImpl(inner.name(), this.dnsZone, inner);
    }
}

