/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.fluent.models.Destination;
import com.azure.resourcemanager.loganalytics.models.Type;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DataExportProperties {
    @JsonProperty(value="dataExportId")
    private String dataExportId;
    @JsonProperty(value="tableNames", required=true)
    private List<String> tableNames;
    @JsonProperty(value="destination")
    private Destination innerDestination;
    @JsonProperty(value="enable")
    private Boolean enable;
    @JsonProperty(value="createdDate")
    private String createdDate;
    @JsonProperty(value="lastModifiedDate")
    private String lastModifiedDate;
    private static final ClientLogger LOGGER = new ClientLogger(DataExportProperties.class);

    public String dataExportId() {
        return this.dataExportId;
    }

    public DataExportProperties withDataExportId(String dataExportId) {
        this.dataExportId = dataExportId;
        return this;
    }

    public List<String> tableNames() {
        return this.tableNames;
    }

    public DataExportProperties withTableNames(List<String> tableNames) {
        this.tableNames = tableNames;
        return this;
    }

    private Destination innerDestination() {
        return this.innerDestination;
    }

    public Boolean enable() {
        return this.enable;
    }

    public DataExportProperties withEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    public String createdDate() {
        return this.createdDate;
    }

    public DataExportProperties withCreatedDate(String createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public DataExportProperties withLastModifiedDate(String lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        return this;
    }

    public String resourceId() {
        return this.innerDestination() == null ? null : this.innerDestination().resourceId();
    }

    public DataExportProperties withResourceId(String resourceId) {
        if (this.innerDestination() == null) {
            this.innerDestination = new Destination();
        }
        this.innerDestination().withResourceId(resourceId);
        return this;
    }

    public Type type() {
        return this.innerDestination() == null ? null : this.innerDestination().type();
    }

    public String eventHubName() {
        return this.innerDestination() == null ? null : this.innerDestination().eventHubName();
    }

    public DataExportProperties withEventHubName(String eventHubName) {
        if (this.innerDestination() == null) {
            this.innerDestination = new Destination();
        }
        this.innerDestination().withEventHubName(eventHubName);
        return this;
    }

    public void validate() {
        if (this.tableNames() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property tableNames in model DataExportProperties"));
        }
        if (this.innerDestination() != null) {
            this.innerDestination().validate();
        }
    }
}

